"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LongWindowDuration = LongWindowDuration;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _duration = require("../../utils/slo/duration");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LongWindowDuration({
  shortWindowDuration,
  initialDuration,
  onChange,
  errors
}) {
  var _initialDuration$valu;
  const [durationValue, setDurationValue] = (0, _react.useState)((_initialDuration$valu = initialDuration === null || initialDuration === void 0 ? void 0 : initialDuration.value) !== null && _initialDuration$valu !== void 0 ? _initialDuration$valu : 1);
  const hasError = errors !== undefined && errors.length > 0;
  const onDurationValueChange = e => {
    const value = Number(e.target.value);
    setDurationValue(value);
    onChange({
      value,
      unit: 'h'
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: getRowLabel(shortWindowDuration),
    fullWidth: true,
    isInvalid: hasError
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: hasError,
    min: 1,
    max: 72,
    step: 1,
    value: String(durationValue),
    onChange: onDurationValueChange,
    "aria-label": _i18n.i18n.translate('xpack.observability.slo.rules.longWindow.valueLabel', {
      defaultMessage: 'Lookback period in hours'
    }),
    "data-test-subj": "durationValueInput"
  }));
}
const getRowLabel = shortWindowDuration => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.slo.rules.longWindow.rowLabel', {
  defaultMessage: 'Lookback (hours)'
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  position: "top",
  content: getTooltipText(shortWindowDuration)
}));
const getTooltipText = shortWindowDuration => _i18n.i18n.translate('xpack.observability.slo.rules.longWindowDuration.tooltip', {
  defaultMessage: 'Lookback period over which the burn rate is computed. A shorter lookback period of {shortWindowDuration} minutes (1/12 the lookback period) will be used for faster recovery',
  values: {
    shortWindowDuration: (0, _duration.toMinutes)(shortWindowDuration)
  }
});