"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRenderCellValue = exports.getMappedNonEcsValue = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _formatters = require("../../../../common/utils/formatters");
var _alert_status_indicator = require("../../alert_status_indicator");
var _timestamp_tooltip = require("../timestamp_tooltip");
var _parse_alert = require("../../../pages/alerts/helpers/parse_alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMappedNonEcsValue = ({
  data,
  fieldName
}) => {
  const item = data.find(d => d.field === fieldName);
  if (item != null && item.value != null) {
    return item.value;
  }
  return undefined;
};
exports.getMappedNonEcsValue = getMappedNonEcsValue;
const getRenderValue = mappedNonEcsValue => {
  // can be updated when working on https://github.com/elastic/kibana/issues/140819
  const value = Array.isArray(mappedNonEcsValue) ? mappedNonEcsValue.join() : mappedNonEcsValue;
  if (!(0, _lodash.isEmpty)(value)) {
    if (typeof value === 'object') {
      return JSON.stringify(value);
    }
    return value;
  }
  return '—';
};

/**
 * This implementation of `EuiDataGrid`'s `renderCellValue`
 * accepts `EuiDataGridCellValueElementProps`, plus `data`
 * from the TGrid
 */

const getRenderCellValue = ({
  setFlyoutAlert,
  observabilityRuleTypeRegistry
}) => {
  return ({
    columnId,
    data
  }) => {
    if (!data) return null;
    const mappedNonEcsValue = getMappedNonEcsValue({
      data,
      fieldName: columnId
    });
    const value = getRenderValue(mappedNonEcsValue);
    switch (columnId) {
      case _ruleDataUtils.ALERT_STATUS:
        if (value !== _ruleDataUtils.ALERT_STATUS_ACTIVE && value !== _ruleDataUtils.ALERT_STATUS_RECOVERED) {
          // NOTE: This should only be needed to narrow down the type.
          // Status should be either "active" or "recovered".
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_alert_status_indicator.AlertStatusIndicator, {
          alertStatus: value
        });
      case _ruleDataUtils.TIMESTAMP:
        return /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
          time: new Date(value !== null && value !== void 0 ? value : '').getTime(),
          timeUnit: "milliseconds"
        });
      case _ruleDataUtils.ALERT_DURATION:
        return (0, _formatters.asDuration)(Number(value));
      case _ruleDataUtils.ALERT_RULE_NAME:
        return value;
      case _ruleDataUtils.ALERT_REASON:
        const dataFieldEs = data.reduce((acc, d) => ({
          ...acc,
          [d.field]: d.value
        }), {});
        const alert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(dataFieldEs);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "o11yGetRenderCellValueLink",
          css: {
            display: 'contents'
          },
          onClick: () => setFlyoutAlert && setFlyoutAlert(alert)
        }, alert.reason);
      default:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
    }
  };
};
exports.getRenderCellValue = getRenderCellValue;