"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHasLogs = getHasLogs;
var _server = require("@kbn/observability-plugin/server");
var _es_fields = require("../../../common/es_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHasLogs({
  type,
  state,
  esClient,
  payload
}) {
  if (!state) {
    return false;
  }
  try {
    const {
      namespace
    } = state;
    const index = type === 'logFiles' ? `logs-${state.datasetName}-${namespace}` : [`logs-system.syslog-${namespace}`, `logs-system.auth-${namespace}`];
    const agentId = payload === null || payload === void 0 ? void 0 : payload.agentId;
    const {
      hits
    } = await esClient.search({
      index,
      ignore_unavailable: true,
      terminate_after: 1,
      body: {
        query: {
          bool: {
            filter: [...(0, _server.termQuery)(_es_fields.AGENT_ID, agentId)]
          }
        }
      }
    });
    const total = hits.total;
    return total.value > 0;
  } catch (error) {
    if (error.statusCode === 404) {
      return false;
    }
    throw error;
  }
}