"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityRoute = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/dataset-quality-plugin/public");
var _page_template = require("../../components/page_template");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _use_kibana = require("../../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasetQualityRoute = ({
  core
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    observabilityShared,
    serverless,
    datasetQuality: DatasetQuality
  } = services;
  const breadcrumb = [{
    text: _public.datasetQualityAppTitle
  }];
  (0, _breadcrumbs.useBreadcrumbs)(breadcrumb, core.chrome, serverless);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_template.ObservabilityLogExplorerPageTemplate, {
    observabilityShared: observabilityShared,
    pageProps: {
      paddingSize: 'l'
    }
  }, /*#__PURE__*/_react.default.createElement(DatasetQuality.DatasetQuality, null)));
};
exports.DatasetQualityRoute = DatasetQualityRoute;