"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityLogExplorerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _locators = require("../common/locators");
var _constants = require("../common/constants");
var _translations = require("../common/translations");
var _observability_log_explorer = require("./applications/observability_log_explorer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityLogExplorerPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "locators", void 0);
    this.config = context.config.get();
  }
  setup(core, _pluginsSetup) {
    const {
      share
    } = _pluginsSetup;
    const useHash = core.uiSettings.get('state:storeInSessionStorage');
    core.application.register({
      id: _constants.OBSERVABILITY_LOG_EXPLORER_APP_ID,
      title: _translations.logExplorerAppTitle,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      euiIconType: 'logoLogging',
      navLinkStatus: this.config.navigation.showAppLink ? _public.AppNavLinkStatus.visible : _public.AppNavLinkStatus.hidden,
      searchable: true,
      keywords: ['logs', 'log', 'explorer', 'logs explorer'],
      mount: async appMountParams => {
        const [coreStart, pluginsStart, ownPluginStart] = await core.getStartServices();
        return (0, _observability_log_explorer.renderObservabilityLogExplorer)(coreStart, pluginsStart, ownPluginStart, appMountParams);
      }
    });

    // Register Locators
    const singleDatasetLocator = share.url.locators.create(new _locators.SingleDatasetLocatorDefinition({
      useHash
    }));
    const allDatasetsLocator = share.url.locators.create(new _locators.AllDatasetsLocatorDefinition({
      useHash
    }));
    this.locators = {
      singleDatasetLocator,
      allDatasetsLocator
    };
    return {
      locators: this.locators
    };
  }
  start(_core, _pluginsStart) {
    return {};
  }
}
exports.ObservabilityLogExplorerPlugin = ObservabilityLogExplorerPlugin;