"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.constructLocatorPath = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const constructLocatorPath = async params => {
  const {
    isFilterPinned
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
  const {
    locatorParams: {
      filters,
      query,
      refreshInterval,
      timeRange,
      columns,
      sort,
      origin
    },
    index,
    useHash
  } = params;
  const appState = {};
  const queryState = {};

  // App state
  if (index) appState.index = index;
  if (query) appState.query = query;
  if (filters && filters.length) appState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => !isFilterPinned(f));
  if (columns) appState.columns = columns;
  if (sort) appState.sort = sort;

  // Global State
  if (timeRange) queryState.time = timeRange;
  if (filters && filters.length) queryState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => isFilterPinned(f));
  if (refreshInterval) queryState.refreshInterval = refreshInterval;
  let path = '/';
  if (Object.keys(queryState).length) {
    path = (0, _common.setStateToKbnUrl)('_g', queryState, {
      useHash,
      storeInHashQuery: false
    }, path);
  }
  path = (0, _common.setStateToKbnUrl)('_a', appState, {
    useHash,
    storeInHashQuery: false
  }, path);
  return {
    app: 'observability-log-explorer',
    path,
    state: {
      ...(origin ? {
        origin
      } : {})
    }
  };
};
exports.constructLocatorPath = constructLocatorPath;