"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllDatasetsLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/log-explorer-plugin/common");
var _locators = require("@kbn/deeplinks-observability/locators");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AllDatasetsLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", _locators.ALL_DATASETS_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", params => {
      const {
        useHash
      } = this.deps;
      const index = _common.AllDatasetSelection.create().toDataviewSpec().id;
      return (0, _utils.constructLocatorPath)({
        locatorParams: params,
        index,
        useHash
      });
    });
    this.deps = deps;
  }
}
exports.AllDatasetsLocatorDefinition = AllDatasetsLocatorDefinition;