"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleLlmResponse = handleLlmResponse;
var _uuid = require("uuid");
var _common = require("../../../common");
var _conversation_complete = require("../../../common/conversation_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function handleLlmResponse({
  signal,
  write,
  source$
}) {
  return new Promise((resolve, reject) => {
    const message = {
      content: '',
      role: _common.MessageRole.Assistant,
      function_call: {
        name: '',
        arguments: '',
        trigger: _common.MessageRole.Assistant
      }
    };
    const id = (0, _uuid.v4)();
    const subscription = source$.subscribe({
      next: chunk => {
        var _delta$function_call, _delta$function_call2;
        const delta = chunk.choices[0].delta;
        message.content += delta.content || '';
        message.function_call.name += ((_delta$function_call = delta.function_call) === null || _delta$function_call === void 0 ? void 0 : _delta$function_call.name) || '';
        message.function_call.arguments += ((_delta$function_call2 = delta.function_call) === null || _delta$function_call2 === void 0 ? void 0 : _delta$function_call2.arguments) || '';
        write({
          type: _conversation_complete.StreamingChatResponseEventType.ChatCompletionChunk,
          message: delta,
          id
        });
      },
      complete: () => {
        resolve({
          id,
          message
        });
      },
      error: error => {
        reject(error);
      }
    });
    signal.addEventListener('abort', () => {
      subscription.unsubscribe();
      reject(new Error('Request aborted'));
    });
  }).then(async ({
    id,
    message
  }) => {
    await write({
      type: _conversation_complete.StreamingChatResponseEventType.MessageAdd,
      message: {
        '@timestamp': new Date().toISOString(),
        message
      },
      id
    });
    return {
      id,
      message
    };
  });
}