"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messageRt = exports.conversationUpdateRt = exports.conversationRt = exports.conversationCreateRt = exports.baseConversationRt = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _types = require("../../common/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serializeableRt = t.any;
const messageRt = t.type({
  '@timestamp': t.string,
  message: t.intersection([t.type({
    role: t.union([t.literal(_types.MessageRole.System), t.literal(_types.MessageRole.Assistant), t.literal(_types.MessageRole.Function), t.literal(_types.MessageRole.User), t.literal(_types.MessageRole.Elastic)])
  }), t.partial({
    content: t.string,
    name: t.string,
    event: t.string,
    function_call: t.intersection([t.type({
      name: t.string,
      trigger: t.union([t.literal(_types.MessageRole.Assistant), t.literal(_types.MessageRole.User), t.literal(_types.MessageRole.Elastic)])
    }), t.partial({
      arguments: serializeableRt,
      data: serializeableRt
    })])
  })])
});
exports.messageRt = messageRt;
const baseConversationRt = t.type({
  '@timestamp': t.string,
  conversation: t.type({
    title: t.string
  }),
  messages: t.array(messageRt),
  labels: t.record(t.string, t.string),
  numeric_labels: t.record(t.string, t.number),
  public: _ioTsUtils.toBooleanRt
});
exports.baseConversationRt = baseConversationRt;
const conversationCreateRt = t.intersection([baseConversationRt, t.type({
  conversation: t.type({
    title: t.string
  })
})]);
exports.conversationCreateRt = conversationCreateRt;
const conversationUpdateRt = t.intersection([baseConversationRt, t.type({
  conversation: t.type({
    id: t.string,
    title: t.string
  })
})]);
exports.conversationUpdateRt = conversationUpdateRt;
const conversationRt = t.intersection([baseConversationRt, t.type({
  user: t.intersection([t.type({
    name: t.string
  }), t.partial({
    id: t.string
  })]),
  namespace: t.string,
  conversation: t.type({
    id: t.string,
    last_updated: t.string
  })
})]);
exports.conversationRt = conversationRt;