"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chatRoutes = void 0;
var _boom = require("@hapi/boom");
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
var _runtime_types = require("../runtime_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const chatRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/chat',
  options: {
    tags: ['access:ai_assistant']
  },
  params: t.intersection([t.type({
    body: t.intersection([t.type({
      messages: t.array(_runtime_types.messageRt),
      connectorId: t.string,
      functions: t.array(t.type({
        name: t.string,
        description: t.string,
        parameters: t.any
      }))
    }), t.partial({
      functionCall: t.string
    })])
  }), t.partial({
    query: t.type({
      stream: _ioTsUtils.toBooleanRt
    })
  })]),
  handler: async resources => {
    const {
      request,
      params,
      service
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const {
      body: {
        messages,
        connectorId,
        functions,
        functionCall
      },
      query = {
        stream: true
      }
    } = params;
    const stream = query.stream;
    const controller = new AbortController();
    request.events.aborted$.subscribe(() => {
      controller.abort();
    });
    return client.chat({
      messages,
      connectorId,
      stream,
      signal: controller.signal,
      ...(functions.length ? {
        functions,
        functionCall
      } : {})
    });
  }
});
const chatCompleteRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/chat/complete',
  options: {
    tags: ['access:ai_assistant']
  },
  params: t.type({
    body: t.intersection([t.type({
      messages: t.array(_runtime_types.messageRt),
      connectorId: t.string,
      persist: _ioTsUtils.toBooleanRt
    }), t.partial({
      conversationId: t.string,
      title: t.string
    })])
  }),
  handler: async resources => {
    const {
      request,
      params,
      service
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const {
      body: {
        messages,
        connectorId,
        conversationId,
        title,
        persist
      }
    } = params;
    const controller = new AbortController();
    request.events.aborted$.subscribe(() => {
      controller.abort();
    });
    const functionClient = await service.getFunctionClient({
      signal: controller.signal,
      resources,
      client
    });
    return client.complete({
      messages,
      connectorId,
      conversationId,
      title,
      persist,
      signal: controller.signal,
      functionClient
    });
  }
});
const chatRoutes = {
  ...chatRoute,
  ...chatCompleteRoute
};
exports.chatRoutes = chatRoutes;