"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaReactStorybookDecorator = KibanaReactStorybookDecorator;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _observability_ai_assistant_chat_service_provider = require("../context/observability_ai_assistant_chat_service_provider");
var _observability_ai_assistant_provider = require("../context/observability_ai_assistant_provider");
var _mock = require("../mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @kbn/imports/no_boundary_crossing

function KibanaReactStorybookDecorator(Story) {
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      triggersActionsUi: {
        getAddRuleFlyout: {}
      },
      uiSettings: {
        get: setting => {
          if (setting === 'dateFormat') {
            return 'MMM D, YYYY HH:mm';
          }
        }
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_provider.ObservabilityAIAssistantProvider, {
    value: _mock.mockService
  }, /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_chat_service_provider.ObservabilityAIAssistantChatServiceProvider, {
    value: _mock.mockChatService
  }, /*#__PURE__*/_react.default.createElement(Story, null))));
}