"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMockChatService = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMockChatService = () => {
  const mockChatService = {
    chat: jest.fn(),
    complete: jest.fn(),
    analytics: {
      optIn: jest.fn(),
      reportEvent: jest.fn(),
      telemetryCounter$: new _rxjs.Observable()
    },
    getContexts: jest.fn().mockReturnValue([{
      name: 'core',
      description: ''
    }]),
    getFunctions: jest.fn().mockReturnValue([]),
    hasFunction: jest.fn().mockReturnValue(false),
    hasRenderFunction: jest.fn().mockReturnValue(true),
    renderFunction: jest.fn()
  };
  return mockChatService;
};
exports.createMockChatService = createMockChatService;