"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAIAssistantPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _create_service = require("./service/create_service");
var _use_genai_connectors = require("./hooks/use_genai_connectors");
var _analytics = require("./analytics");
var _observability_ai_assistant_provider = require("./context/observability_ai_assistant_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class ObservabilityAIAssistantPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "service", void 0);
    this.logger = context.logger.get();
  }
  setup(coreSetup, pluginsSetup) {
    coreSetup.application.register({
      id: 'observabilityAIAssistant',
      title: _i18n.i18n.translate('xpack.observabilityAiAssistant.appTitle', {
        defaultMessage: 'Observability AI Assistant'
      }),
      euiIconType: 'logoObservability',
      appRoute: '/app/observabilityAIAssistant',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      navLinkStatus: _public.AppNavLinkStatus.hidden,
      deepLinks: [{
        id: 'conversations',
        title: _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationsDeepLinkTitle', {
          defaultMessage: 'Conversations'
        }),
        path: '/conversations/new'
      }],
      mount: async appMountParameters => {
        // Load application bundle and Get start services
        const [{
          Application
        }, [coreStart, pluginsStart]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application'))), coreSetup.getStartServices()]);
        _reactDom.default.render( /*#__PURE__*/_react.default.createElement(Application, (0, _extends2.default)({}, appMountParameters, {
          service: this.service,
          coreStart: coreStart,
          pluginsStart: pluginsStart
        })), appMountParameters.element);
        return () => {
          _reactDom.default.unmountComponentAtNode(appMountParameters.element);
        };
      }
    });
    (0, _analytics.registerTelemetryEventTypes)(coreSetup.analytics);
    return {};
  }
  start(coreStart, pluginsStart) {
    const service = this.service = (0, _create_service.createService)({
      analytics: coreStart.analytics,
      coreStart,
      enabled: coreStart.application.capabilities.observabilityAIAssistant.show === true,
      licenseStart: pluginsStart.licensing,
      securityStart: pluginsStart.security,
      shareStart: pluginsStart.share
    });
    service.register(async ({
      registerRenderFunction
    }) => {
      const mod = await Promise.resolve().then(() => _interopRequireWildcard(require('./functions')));
      return mod.registerFunctions({
        service,
        pluginsStart,
        registerRenderFunction
      });
    });
    const withProviders = (Component, services) => /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: services
    }, /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_provider.ObservabilityAIAssistantProvider, {
      value: service
    }, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
      ref: ref
    })))));
    const services = {
      ...coreStart,
      plugins: {
        start: pluginsStart
      }
    };
    const isEnabled = service.isEnabled();
    return {
      service,
      useGenAIConnectors: () => (0, _use_genai_connectors.useGenAIConnectorsWithoutContext)(service),
      ObservabilityAIAssistantContextualInsight: isEnabled ? (0, _sharedUxUtility.withSuspense)(withProviders( /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/insight/insight'))).then(m => ({
        default: m.Insight
      }))), services)) : null,
      ObservabilityAIAssistantActionMenuItem: isEnabled ? (0, _sharedUxUtility.withSuspense)(withProviders( /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/action_menu_item/action_menu_item'))).then(m => ({
        default: m.ObservabilityAIAssistantActionMenuItem
      }))), services)) : null
    };
  }
}
exports.ObservabilityAIAssistantPlugin = ObservabilityAIAssistantPlugin;