"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservabilityAIAssistantChatService = useObservabilityAIAssistantChatService;
var _react = require("react");
var _observability_ai_assistant_chat_service_provider = require("../context/observability_ai_assistant_chat_service_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useObservabilityAIAssistantChatService() {
  const services = (0, _react.useContext)(_observability_ai_assistant_chat_service_provider.ObservabilityAIAssistantChatServiceContext);
  if (!services) {
    throw new Error('ObservabilityAIAssistantChatServiceContext not set. Did you wrap your component in `<ObservabilityAIAssistantChatServiceProvider/>`?');
  }
  return services;
}