"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptEditorFunction = PromptEditorFunction;
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _css = require("@emotion/css");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_json_editor_model = require("../../hooks/use_json_editor_model");
var _common = require("../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const functionNameClassName = (0, _css.css)`
  display: inline-block;
`;
function PromptEditorFunction({
  functionName,
  functionPayload,
  onChange,
  onFocus,
  onBlur
}) {
  var _editorRef$current;
  const editorRef = (0, _react.useRef)(null);
  const [functionEditorLineCount, setFunctionEditorLineCount] = (0, _react.useState)(0);
  const previousPayload = (0, _usePrevious.default)(functionPayload);
  const {
    model,
    initialJsonString
  } = (0, _use_json_editor_model.useJsonEditorModel)({
    functionName,
    initialJson: functionPayload
  });
  const handleChangePayload = args => {
    recalculateLineCount();
    onChange({
      role: _common.MessageRole.Assistant,
      content: '',
      function_call: {
        name: functionName,
        trigger: _common.MessageRole.User,
        arguments: args
      }
    });
  };
  const recalculateLineCount = (0, _react.useCallback)(() => {
    const newLineCount = (model === null || model === void 0 ? void 0 : model.getLineCount()) || 0;
    if (newLineCount !== functionEditorLineCount) {
      setFunctionEditorLineCount(newLineCount + 1);
    }
  }, [functionEditorLineCount, model]);
  (0, _react.useEffect)(() => {
    recalculateLineCount();
  }, [model, recalculateLineCount]);
  (0, _react.useEffect)(() => {
    if (previousPayload === undefined && initialJsonString) {
      onChange({
        role: _common.MessageRole.Assistant,
        content: '',
        function_call: {
          name: functionName,
          trigger: _common.MessageRole.User,
          arguments: initialJsonString
        }
      });
    }
  }, [functionName, functionPayload, initialJsonString, onChange, previousPayload]);
  (_editorRef$current = editorRef.current) === null || _editorRef$current === void 0 ? void 0 : _editorRef$current.onDidBlurEditorWidget(() => {
    onBlur();
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    className: functionNameClassName
  }, functionName), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatPromptEditor.codeEditor.payloadEditorLabel', {
      defaultMessage: 'payloadEditor'
    }),
    "data-test-subj": "observabilityAiAssistantChatPromptEditorCodeEditor",
    editorDidMount: editor => {
      editorRef.current = editor;
      editor.focus();
      onFocus();
    },
    fullWidth: true,
    height: '180px',
    isCopyable: true,
    languageId: "json",
    languageConfiguration: {
      autoClosingPairs: [{
        open: '{',
        close: '}'
      }]
    },
    options: {
      accessibilitySupport: 'off',
      acceptSuggestionOnEnter: 'on',
      automaticLayout: true,
      autoClosingQuotes: 'always',
      autoIndent: 'full',
      contextmenu: true,
      fontSize: 12,
      formatOnPaste: true,
      formatOnType: true,
      inlineHints: {
        enabled: true
      },
      lineNumbers: 'on',
      minimap: {
        enabled: false
      },
      model,
      overviewRulerBorder: false,
      quickSuggestions: true,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      scrollBeyondLastLine: false,
      suggestOnTriggerCharacters: true,
      tabSize: 2,
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    transparentBackground: true,
    value: functionPayload || '',
    onChange: handleChangePayload
  }));
}