"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatFlyout = ChatFlyout;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_current_user = require("../../hooks/use_current_user");
var _use_genai_connectors = require("../../hooks/use_genai_connectors");
var _use_kibana = require("../../hooks/use_kibana");
var _use_knowledge_base = require("../../hooks/use_knowledge_base");
var _use_observability_ai_assistant_router = require("../../hooks/use_observability_ai_assistant_router");
var _get_connectors_management_href = require("../../utils/get_connectors_management_href");
var _chat_body = require("./chat_body");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containerClassName = (0, _css.css)`
  max-height: 100%;
`;
const bodyClassName = (0, _css.css)`
  overflow-y: auto;
`;
function ChatFlyout({
  initialTitle,
  initialMessages,
  onClose,
  isOpen,
  startedFrom
}) {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const currentUser = (0, _use_current_user.useCurrentUser)();
  const connectors = (0, _use_genai_connectors.useGenAIConnectors)();
  const router = (0, _use_observability_ai_assistant_router.useObservabilityAIAssistantRouter)();
  const knowledgeBase = (0, _use_knowledge_base.useKnowledgeBase)();
  const [conversationId, setConversationId] = (0, _react.useState)(undefined);
  const conversationsHeaderClassName = (0, _css.css)`
    padding-top: 12px;
    padding-bottom: 12px;
    border-bottom: solid 1px ${euiTheme.border.color};
  `;
  return isOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    direction: "column",
    className: containerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    borderRadius: "none",
    className: conversationsHeaderClassName
  }, conversationId ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "observabilityAiAssistantChatFlyoutOpenConversationLink",
    href: router.link('/conversations/{conversationId}', {
      path: {
        conversationId
      }
    })
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationDeepLinkLabel', {
    defaultMessage: 'Open conversation'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "observabilityAiAssistantChatFlyoutGoToConversationsLink",
    href: router.link('/conversations/new')
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationListDeepLinkLabel', {
    defaultMessage: 'Go to conversations'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: bodyClassName
  }, /*#__PURE__*/_react.default.createElement(_chat_body.ChatBody, {
    connectors: connectors,
    initialTitle: initialTitle,
    initialMessages: initialMessages,
    currentUser: currentUser,
    connectorsManagementHref: (0, _get_connectors_management_href.getConnectorsManagementHref)(http),
    knowledgeBase: knowledgeBase,
    startedFrom: startedFrom,
    onConversationUpdate: conversation => {
      setConversationId(conversation.conversation.id);
    }
  })))) : null;
}