"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HideExpandConversationListButton = HideExpandConversationListButton;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HideExpandConversationListButton(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "observabilityAiAssistantHideExpandConversationListButton",
    iconType: props.isExpanded ? 'menuLeft' : 'menuRight',
    size: "xs"
  }, props), props.isExpanded ? _i18n.i18n.translate('xpack.observabilityAiAssistant.hideExpandConversationButton.hide', {
    defaultMessage: 'Hide chats'
  }) : _i18n.i18n.translate('xpack.observabilityAiAssistant.hideExpandConversationButton.show', {
    defaultMessage: 'Show chats'
  }));
}