"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AskAssistantButton = AskAssistantButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AskAssistantButton({
  fill,
  flush,
  size,
  variant,
  onClick
}) {
  const buttonLabel = _i18n.i18n.translate('xpack.observabilityAiAssistant.askAssistantButton.buttonLabel', {
    defaultMessage: 'Ask Assistant'
  });
  switch (variant) {
    case 'basic':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "observabilityAiAssistantAskAssistantButton",
        fill: fill,
        size: size,
        iconType: "sparkles",
        onClick: onClick
      }, buttonLabel);
    case 'empty':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "observabilityAiAssistantAskAssistantButton",
        size: size,
        flush: flush,
        iconType: "sparkles",
        onClick: onClick
      }, buttonLabel);
    case 'iconOnly':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        title: _i18n.i18n.translate('xpack.observabilityAiAssistant.askAssistantButton.popoverTitle', {
          defaultMessage: 'AI Assistant for Observability'
        }),
        content: _i18n.i18n.translate('xpack.observabilityAiAssistant.askAssistantButton.popoverContent', {
          defaultMessage: 'Get insights into your data with the Elastic Assistant'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.askAssistantButton.popoverTitle', {
          defaultMessage: 'AI Assistant for Observability'
        }),
        "data-test-subj": "observabilityAiAssistantAskAssistantButtonButtonIcon",
        display: fill ? 'fill' : 'base',
        iconType: "sparkles",
        size: size,
        style: {
          minWidth: 'auto'
        },
        onClick: onClick
      }));
  }
}