"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAIAssistantActionMenuItem = ObservabilityAIAssistantActionMenuItem;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _observability_ai_assistant_chat_service_provider = require("../../context/observability_ai_assistant_chat_service_provider");
var _use_abortable_async = require("../../hooks/use_abortable_async");
var _use_observability_ai_assistant = require("../../hooks/use_observability_ai_assistant");
var _assistant_avatar = require("../assistant_avatar");
var _chat_flyout = require("../chat/chat_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ObservabilityAIAssistantActionMenuItem() {
  const service = (0, _use_observability_ai_assistant.useObservabilityAIAssistant)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const chatService = (0, _use_abortable_async.useAbortableAsync)(({
    signal
  }) => {
    if (!isOpen) {
      return Promise.resolve(undefined);
    }
    return service.start({
      signal
    });
  }, [service, isOpen]);
  const initialMessages = (0, _react.useMemo)(() => [], []);
  if (!service.isEnabled()) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    "data-test-subj": "observabilityAiAssistantNewChatHeaderLink",
    onClick: () => {
      setIsOpen(() => true);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !isOpen || chatService.value ? /*#__PURE__*/_react.default.createElement(_assistant_avatar.AssistantAvatar, {
    size: "xs"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.actionMenuItemLabel', {
    defaultMessage: 'AI Assistant'
  })))), chatService.value ? /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_chat_service_provider.ObservabilityAIAssistantChatServiceProvider, {
    value: chatService.value
  }, /*#__PURE__*/_react.default.createElement(_chat_flyout.ChatFlyout, {
    initialTitle: "",
    initialMessages: initialMessages,
    isOpen: isOpen,
    startedFrom: "appTopNavbar",
    onClose: () => {
      setIsOpen(false);
    }
  })) : null);
}