"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListingCallOut = ListingCallOut;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatting = require("./formatting");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIGRATE_TO_MB_LABEL = _i18n.i18n.translate('xpack.monitoring.setupMode.migrateToMetricbeat', {
  defaultMessage: 'Monitor with Metricbeat'
});
function ListingCallOut({
  setupModeData,
  productName,
  customRenderer
}) {
  if (customRenderer) {
    const {
      shouldRender,
      componentToRender
    } = customRenderer();
    if (shouldRender) {
      return componentToRender;
    }
  }
  const mightExist = (0, _lodash.get)(setupModeData, 'detected.mightExist');
  const hasInstances = setupModeData.totalUniqueInstanceCount > 0;
  if (!hasInstances) {
    if (mightExist) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.monitoring.setupMode.detectedNodeTitle', {
          defaultMessage: '{product} {identifier} detected',
          values: {
            product: (0, _formatting.formatProductName)(productName),
            identifier: (0, _formatting.getIdentifier)(productName)
          }
        }),
        color: "warning",
        iconType: "flag"
      }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.setupMode.detectedNodeDescription', {
        defaultMessage: `Click 'Set up monitoring' below to start monitoring this {identifier}.`,
        values: {
          identifier: (0, _formatting.getIdentifier)(productName)
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.monitoring.setupMode.noMonitoringDataFound', {
        defaultMessage: 'No {product} {identifier} detected',
        values: {
          product: (0, _formatting.formatProductName)(productName),
          identifier: (0, _formatting.getIdentifier)(productName, true)
        }
      }),
      iconType: "flag"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.setupMode.netNewUserDescription', {
      defaultMessage: `Click 'Set up monitoring' to start monitoring with Metricbeat.`
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  if (setupModeData.totalUniqueFullyMigratedCount === setupModeData.totalUniqueInstanceCount) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.monitoring.setupMode.metricbeatAllNodes', {
        defaultMessage: 'Metricbeat is monitoring all {identifier}.',
        values: {
          identifier: (0, _formatting.getIdentifier)(productName, true)
        }
      }),
      color: "success",
      iconType: "flag"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  if (setupModeData.totalUniquePartiallyMigratedCount === setupModeData.totalUniqueInstanceCount) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.monitoring.setupMode.disableInternalCollectionTitle', {
        defaultMessage: 'Disable self monitoring'
      }),
      color: "warning",
      iconType: "flag"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.setupMode.disableInternalCollectionDescription', {
      defaultMessage: `Metricbeat is now monitoring your {product} {identifier}. Disable self monitoring to finish the migration.`,
      values: {
        product: (0, _formatting.formatProductName)(productName),
        identifier: (0, _formatting.getIdentifier)(productName, true)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  if (setupModeData.totalUniqueInstanceCount > 0) {
    if (setupModeData.totalUniqueFullyMigratedCount === 0 && setupModeData.totalUniquePartiallyMigratedCount === 0) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: MIGRATE_TO_MB_LABEL,
        color: "danger",
        iconType: "flag"
      }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.setupMode.migrateToMetricbeatDescription', {
        defaultMessage: `These {product} {identifier} are self monitored.
                Click 'Monitor with Metricbeat' to migrate.`,
        values: {
          product: (0, _formatting.formatProductName)(productName),
          identifier: (0, _formatting.getIdentifier)(productName, true)
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: MIGRATE_TO_MB_LABEL,
      color: "danger",
      iconType: "flag"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.setupMode.migrateSomeToMetricbeatDescription', {
      defaultMessage: `Some {product} {identifier} are monitored through self monitoring. Migrate to monitor with Metricbeat.`,
      values: {
        product: (0, _formatting.formatProductName)(productName),
        identifier: (0, _formatting.getIdentifier)(productName, true)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  return null;
}