"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticsearchInstructionsForEnablingMetricbeat = getElasticsearchInstructionsForEnablingMetricbeat;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _monospace = require("../components/monospace");
var _i18nReact = require("@kbn/i18n-react");
var _legacy_shims = require("../../../../legacy_shims");
var _common_instructions = require("../common_instructions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getElasticsearchInstructionsForEnablingMetricbeat(product, _meta, {
  esMonitoringUrl
}) {
  const elasticsearchUrl = _legacy_shims.Legacy.shims.docLinks.links.monitoring.monitorElasticsearch;
  const metricbeatInstallUrl = _legacy_shims.Legacy.shims.docLinks.links.metricbeat.install;
  const metricbeatStartUrl = _legacy_shims.Legacy.shims.docLinks.links.metricbeat.start;
  const securitySetup = (0, _common_instructions.getSecurityStep)(elasticsearchUrl);
  const installMetricbeatStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.elasticsearchInstructions.installMetricbeatTitle', {
      defaultMessage: 'Install Metricbeat on the same server as Elasticsearch'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: metricbeatInstallUrl,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.elasticsearchInstructions.installMetricbeatLinkText",
      defaultMessage: "Follow these instructions."
    }))))
  };
  const enableMetricbeatModuleStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.elasticsearchInstructions.enableMetricbeatModuleTitle', {
      defaultMessage: 'Enable and configure the Elasticsearch x-pack module in Metricbeat'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.elasticsearchInstructions.enableMetricbeatModuleInstallDirectory', {
      defaultMessage: 'From the installation directory, run:'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      language: "bash"
    }, "metricbeat modules enable elasticsearch-xpack"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.elasticsearchInstructions.enableMetricbeatModuleDescription",
      defaultMessage: "By default the module collects Elasticsearch metrics from {url}. If the local server has a different address, add it to the hosts setting in {module}.",
      values: {
        module: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "modules.d/elasticsearch-xpack.yml"),
        url: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "http://localhost:9200")
      }
    }))), securitySetup)
  };
  const configureMetricbeatStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.elasticsearchInstructions.configureMetricbeatTitle', {
      defaultMessage: 'Configure Metricbeat to send data to the monitoring cluster'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.elasticsearchInstructions.configureMetricbeatDescription",
      defaultMessage: "Modify {file} to set the connection information.",
      values: {
        file: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "metricbeat.yml")
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true
    }, `output.elasticsearch:
  hosts: [${esMonitoringUrl}] ## Monitoring cluster

  # Optional protocol and basic auth credentials.
  #protocol: "https"
  #username: "elastic"
  #password: "changeme"
`), securitySetup)
  };
  const startMetricbeatStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.elasticsearchInstructions.startMetricbeatTitle', {
      defaultMessage: 'Start Metricbeat'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: metricbeatStartUrl,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.elasticsearchInstructions.startMetricbeatLinkText",
      defaultMessage: "Follow these instructions."
    }))))
  };
  const migrationStatusStep = (0, _common_instructions.getMigrationStatusStep)(product);
  return [installMetricbeatStep, enableMetricbeatModuleStep, configureMetricbeatStep, startMetricbeatStep, migrationStatusStep];
}