"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardActivity = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _table = require("../../table");
var _recovery_index = require("./recovery_index");
var _total_time = require("./total_time");
var _source_destination = require("./source_destination");
var _progress = require("./progress");
var _parse_props = require("./parse_props");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columns = [{
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.indexTitle', {
    defaultMessage: 'Index'
  }),
  field: 'name',
  render: (_name, shard) => /*#__PURE__*/_react.default.createElement(_recovery_index.RecoveryIndex, shard)
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.stageTitle', {
    defaultMessage: 'Stage'
  }),
  field: 'stage'
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.totalTimeTitle', {
    defaultMessage: 'Total Time'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_total_time.TotalTime, shard)
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.sourceDestinationTitle', {
    defaultMessage: 'Source / Destination'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_source_destination.SourceDestination, shard)
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.filesTitle', {
    defaultMessage: 'Files'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_progress.FilesProgress, shard)
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.bytesTitle', {
    defaultMessage: 'Bytes'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_progress.BytesProgress, shard)
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.translogTitle', {
    defaultMessage: 'Translog'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_progress.TranslogProgress, shard)
}];
const ShardActivity = props => {
  var _services$uiSettings;
  const {
    data: rawData,
    sorting,
    pagination,
    onTableChange,
    toggleShardActivityHistory,
    showShardActivityHistory
  } = props;
  const {
    services
  } = (0, _public.useKibana)();
  const timezone = (_services$uiSettings = services.uiSettings) === null || _services$uiSettings === void 0 ? void 0 : _services$uiSettings.get('dateFormat:tz');
  const getNoDataMessage = () => {
    if (showShardActivityHistory) {
      return _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardActivity.noDataMessage', {
        defaultMessage: 'There are no historical shard activity records for the selected time range.'
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.shardActivity.noActiveShardRecoveriesMessage.completedRecoveriesLinkTextProblem",
      defaultMessage: "There are no active shard recoveries for this cluster."
    }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.shardActivity.noActiveShardRecoveriesMessage.completedRecoveriesLinkTextSolution",
      defaultMessage: "Try viewing {shardActivityHistoryLink}.",
      values: {
        shardActivityHistoryLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: toggleShardActivityHistory
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.monitoring.elasticsearch.shardActivity.noActiveShardRecoveriesMessage.completedRecoveriesLinkText",
          defaultMessage: "completed recoveries"
        }))
      }
    }));
  };
  const rows = rawData.map(data => (0, _parse_props.parseProps)({
    ...data,
    timezone
  }));
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.shardActivityTitle",
    defaultMessage: "Shard Activity"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "monitoring_completed_recoveries",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.shardActivity.completedRecoveriesLabel",
      defaultMessage: "Completed recoveries"
    }),
    onChange: toggleShardActivityHistory,
    checked: showShardActivityHistory
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
    className: "esShardActivityTable",
    rows: rows,
    columns: columns,
    message: getNoDataMessage(),
    sorting: sorting,
    search: false,
    pagination: pagination,
    onTableChange: onTableChange,
    executeQueryOptions: {
      defaultFields: ['name']
    }
  }));
};
exports.ShardActivity = ShardActivity;