"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Listing = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ = require("..");
var _format_number = require("../../../lib/format_number");
var _table = require("../../table");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _listing_callout = require("../../setup_mode/listing_callout");
var _badge = require("../../setup_mode/badge");
var _i18nReact = require("@kbn/i18n-react");
var _setup_mode = require("../../../lib/setup_mode");
var _enums = require("../../../../common/enums");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Listing extends _react.PureComponent {
  getColumns() {
    const setupMode = this.props.setupMode;
    return [{
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.nameTitle', {
        defaultMessage: 'Name'
      }),
      field: 'name',
      render: (name, beat) => {
        let setupModeStatus = null;
        if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
          const list = (0, _lodash.get)(setupMode, 'data.byUuid', {});
          const status = list[beat.uuid] || {};
          const instance = {
            uuid: beat.uuid,
            name: beat.name
          };
          setupModeStatus = /*#__PURE__*/_react.default.createElement("div", {
            className: "monTableCell__setupModeStatus"
          }, /*#__PURE__*/_react.default.createElement(_badge.SetupModeBadge, {
            setupMode: setupMode,
            status: status,
            instance: instance,
            productName: _constants.BEATS_SYSTEM_ID
          }));
        }
        return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/beats/beat/${beat.uuid}`),
          "data-test-subj": `beatLink-${name}`
        }, name), setupModeStatus);
      }
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.typeTitle', {
        defaultMessage: 'Type'
      }),
      field: 'type'
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.outputEnabledTitle', {
        defaultMessage: 'Output Enabled'
      }),
      field: 'output'
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.totalEventsRateTitle', {
        defaultMessage: 'Total Events Rate'
      }),
      field: 'total_events_rate',
      render: value => (0, _format_number.formatMetric)(value, '', '/s')
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.bytesSentRateTitle', {
        defaultMessage: 'Bytes Sent Rate'
      }),
      field: 'bytes_sent_rate',
      render: value => (0, _format_number.formatMetric)(value, 'byte', '/s')
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.outputErrorsTitle', {
        defaultMessage: 'Output Errors'
      }),
      field: 'errors',
      render: value => (0, _format_number.formatMetric)(value, '0')
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.allocatedMemoryTitle', {
        defaultMessage: 'Allocated Memory'
      }),
      field: 'memory',
      render: value => (0, _format_number.formatMetric)(value, 'byte')
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.versionTitle', {
        defaultMessage: 'Version'
      }),
      field: 'version'
    }];
  }
  render() {
    const {
      stats,
      data,
      sorting,
      pagination,
      onTableChange,
      setupMode
    } = this.props;
    let setupModeCallOut = null;
    if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
      setupModeCallOut = /*#__PURE__*/_react.default.createElement(_listing_callout.ListingCallOut, {
        setupModeData: setupMode.data,
        useNodeIdentifier: false,
        productName: _constants.BEATS_SYSTEM_ID
      });
    }
    const types = (0, _lodash.uniq)(data.map(item => item.type)).map(type => {
      return {
        value: type
      };
    });
    const versions = (0, _lodash.uniq)(data.map(item => item.version)).map(version => {
      return {
        value: version
      };
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.beats.listing.heading",
      defaultMessage: "Beats listing"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_.Stats, {
      stats: stats
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, setupModeCallOut, /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
      className: "beatsTable",
      rows: data,
      setupMode: setupMode,
      productName: _constants.BEATS_SYSTEM_ID,
      columns: this.getColumns(),
      sorting: sorting,
      pagination: pagination,
      search: {
        box: {
          incremental: true,
          placeholder: _i18n.i18n.translate('xpack.monitoring.beats.filterBeatsPlaceholder', {
            defaultMessage: 'Filter Beats...'
          })
        },
        filters: [{
          type: 'field_value_selection',
          field: 'type',
          name: _i18n.i18n.translate('xpack.monitoring.beats.instances.typeFilter', {
            defaultMessage: 'Type'
          }),
          options: types,
          multiSelect: 'or'
        }, {
          type: 'field_value_selection',
          field: 'version',
          name: _i18n.i18n.translate('xpack.monitoring.beats.instances.versionFilter', {
            defaultMessage: 'Version'
          }),
          options: versions,
          multiSelect: 'or'
        }]
      },
      onTableChange: onTableChange,
      executeQueryOptions: {
        defaultFields: ['name', 'type']
      }
    }))));
  }
}
exports.Listing = Listing;