"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _no_data = require("../../../components/no_data");
var _page_template = require("../page_template");
var _constants = require("../../../../common/constants");
var _legacy_shims = require("../../../legacy_shims");
var _enabler = require("./enabler");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _setup_mode = require("../../../lib/setup_mode");
var _global_state_context = require("../../contexts/global_state_context");
var _use_request_error_handler = require("../../hooks/use_request_error_handler");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CODE_PATHS = [_constants.CODE_PATH_LICENSE];
const clusterCheckers = [{
  message: _i18n.i18n.translate('xpack.monitoring.noData.checker.clusterSettings', {
    defaultMessage: 'Checking cluster settings API on production cluster'
  }),
  api: '../api/monitoring/v1/elasticsearch_settings/check/cluster'
}, {
  message: _i18n.i18n.translate('xpack.monitoring.noData.checker.nodesSettings', {
    defaultMessage: 'Checking nodes settings API on production cluster'
  }),
  api: '../api/monitoring/v1/elasticsearch_settings/check/nodes'
}];
const NoDataPage = () => {
  const title = _i18n.i18n.translate('xpack.monitoring.noData.routeTitle', {
    defaultMessage: 'Setup Monitoring'
  });
  const {
    services
  } = (0, _public.useKibana)();
  const [shouldRedirect, setShouldRedirect] = (0, _react.useState)(false);
  const [model, setModel] = (0, _react.useState)({
    errors: [],
    // errors can happen from trying to check or set ES settings
    checkMessage: null,
    // message to show while waiting for api response
    isLoading: true,
    // flag for in-progress state of checking for no data reason
    isCollectionEnabledUpdating: false,
    // flags to indicate whether to show a spinner while waiting for ajax
    isCollectionEnabledUpdated: false,
    isCollectionIntervalUpdating: false,
    isCollectionIntervalUpdated: false
  });
  const {
    update: updateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  updateBreadcrumbs([{
    'data-test-subj': 'breadcrumbClusters',
    text: 'Clusters',
    href: '#/home',
    ignoreGlobalState: true
  }]);
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const handleRequestError = (0, _use_request_error_handler.useRequestErrorHandler)();
  (0, _setup_mode.initSetupModeState)(globalState, services.http, handleRequestError);

  // From x-pack/plugins/monitoring/public/views/no_data/model_updater.js
  const updateModel = (0, _react.useCallback)(properties => {
    setModel(previousModel => {
      const updated = {
        ...previousModel
      };
      const keys = Object.keys(properties);
      keys.forEach(key => {
        if (Array.isArray(updated[key])) {
          updated[key].push(properties[key]);
        } else {
          updated[key] = properties[key];
        }
      });
      return updated;
    });
  }, [setModel]);
  const getPageData = (0, _react.useCallback)(async () => {
    let catchReason;
    try {
      const clusters = await getClusters(services);
      if (clusters && clusters.length) {
        setShouldRedirect(true);
        return;
      }
    } catch (err) {
      if (err && err.status === 503) {
        catchReason = {
          property: 'custom',
          message: err.data.message
        };
      }
    }
    if (catchReason) {
      updateModel({
        reason: catchReason
      });
    } else {
      await startChecks(clusterCheckers, services.http, updateModel);
    }
  }, [services, updateModel]);
  const enabler = new _enabler.Enabler(services.http, updateModel);
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
    title: title,
    getPageData: getPageData
  }, shouldRedirect ? /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/home"
  }) : /*#__PURE__*/_react.default.createElement(_no_data.NoData, (0, _extends2.default)({}, model, {
    enabler: enabler,
    isCloudEnabled: _legacy_shims.Legacy.shims.isCloud
  })));
};
exports.NoDataPage = NoDataPage;
async function getClusters(services) {
  var _services$data, _services$http;
  const url = '../api/monitoring/v1/clusters';
  const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
  const min = bounds.min.toISOString();
  const max = bounds.max.toISOString();
  const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
    method: 'POST',
    body: JSON.stringify({
      css: undefined,
      timeRange: {
        min,
        max
      },
      codePaths: CODE_PATHS
    })
  }));
  return formatClusters(response);
}

// From x-pack/plugins/monitoring/public/lib/elasticsearch_settings/start_checks.js
const mapCheckers = _checkers => {
  return _checkers.map((current, checkerIndex) => {
    const next = _checkers[checkerIndex + 1];
    if (next !== undefined) {
      current.next = next;
    }
    return current;
  });
};

// From x-pack/plugins/monitoring/public/lib/elasticsearch_settings/start_checks.js
function startChecks(checkers, http, updateModel) {
  const runCheck = async currentChecker => {
    updateModel({
      checkMessage: currentChecker.message
    });
    const {
      found,
      reason,
      error,
      errorReason
    } = await executeCheck(currentChecker, http);
    if (error) {
      updateModel({
        errors: errorReason
      });
      if (currentChecker.next) {
        return runCheck(currentChecker.next);
      }
    } else if (found) {
      return updateModel({
        reason,
        isLoading: false,
        checkMessage: null
      });
    } else if (currentChecker.next) {
      return runCheck(currentChecker.next);
    }

    // dead end
    updateModel({
      reason: null,
      isLoading: false,
      checkMessage: null
    });
  };
  const _checkers = mapCheckers(checkers);
  return runCheck(_checkers[0]);
}
async function executeCheck(checker, http) {
  try {
    const response = await http.fetch(checker.api, {
      method: 'GET'
    });
    const {
      found,
      reason
    } = response;
    return {
      found,
      reason
    };
  } catch (err) {
    return {
      error: true,
      found: false,
      errorReason: err.body
    };
  }
}
function formatClusters(clusters) {
  return clusters.map(formatCluster);
}
function formatCluster(cluster) {
  if (cluster.cluster_uuid === _constants.STANDALONE_CLUSTER_CLUSTER_UUID) {
    cluster.cluster_name = 'Standalone Cluster';
  }
  return cluster;
}