"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _constants = require("../../common/constants");
var _external_config_context = require("./contexts/external_config_context");
var _global_state_context = require("./contexts/global_state_context");
var _header_action_menu_context = require("./contexts/header_action_menu_context");
var _use_breadcrumbs = require("./hooks/use_breadcrumbs");
var _use_monitoring_time = require("./hooks/use_monitoring_time");
var _access_denied = require("./pages/access_denied");
var _apm = require("./pages/apm");
var _instance = require("./pages/beats/instance");
var _instances = require("./pages/beats/instances");
var _overview = require("./pages/beats/overview");
var _overview_page = require("./pages/cluster/overview_page");
var _ccr_page = require("./pages/elasticsearch/ccr_page");
var _ccr_shard_page = require("./pages/elasticsearch/ccr_shard_page");
var _index_advanced_page = require("./pages/elasticsearch/index_advanced_page");
var _index_page = require("./pages/elasticsearch/index_page");
var _indices_page = require("./pages/elasticsearch/indices_page");
var _ml_jobs_page = require("./pages/elasticsearch/ml_jobs_page");
var _nodes_page = require("./pages/elasticsearch/nodes_page");
var _node_advanced_page = require("./pages/elasticsearch/node_advanced_page");
var _node_page = require("./pages/elasticsearch/node_page");
var _overview2 = require("./pages/elasticsearch/overview");
var _overview3 = require("./pages/enterprise_search/overview");
var _cluster_listing = require("./pages/home/cluster_listing");
var _instance2 = require("./pages/kibana/instance");
var _instances2 = require("./pages/kibana/instances");
var _overview4 = require("./pages/kibana/overview");
var _license_page = require("./pages/license_page");
var _loading_page = require("./pages/loading_page");
var _advanced = require("./pages/logstash/advanced");
var _node = require("./pages/logstash/node");
var _nodes = require("./pages/logstash/nodes");
var _node_pipelines = require("./pages/logstash/node_pipelines");
var _overview5 = require("./pages/logstash/overview");
var _pipeline = require("./pages/logstash/pipeline");
var _pipelines = require("./pages/logstash/pipelines");
var _no_data = require("./pages/no_data");
var _preserve_query_history = require("./preserve_query_history");
var _route_init = require("./route_init");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// import { LogStashNodePipelinesPage } from './pages/logstash/node_pipelines';

const renderApp = (core, plugins, {
  element,
  history,
  setHeaderActionMenu,
  theme$
}, externalConfig) => {
  // dispatch synthetic hash change event to update hash history objects
  // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
  const unlistenParentHistory = history.listen(() => {
    window.dispatchEvent(new HashChangeEvent('hashchange'));
  });
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(MonitoringApp, {
    core: core,
    plugins: plugins,
    externalConfig: externalConfig,
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
    unlistenParentHistory();
  };
};
exports.renderApp = renderApp;
const MonitoringApp = ({
  core,
  plugins,
  externalConfig,
  setHeaderActionMenu,
  theme$
}) => {
  const history = (0, _preserve_query_history.createPreserveQueryHistory)();
  const darkModeObservable = (0, _react.useMemo)(() => core.uiSettings.get$('theme:darkMode'), [core.uiSettings]);
  const darkMode = (0, _useObservable.default)(darkModeObservable, core.uiSettings.get('theme:darkMode'));
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: darkMode
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: core.theme.theme$
  }, /*#__PURE__*/_react.default.createElement(_external_config_context.ExternalConfigContext.Provider, {
    value: externalConfig
  }, /*#__PURE__*/_react.default.createElement(_global_state_context.GlobalStateProvider, {
    query: plugins.data.query,
    toasts: core.notifications.toasts,
    uiSettings: core.uiSettings
  }, /*#__PURE__*/_react.default.createElement(_header_action_menu_context.HeaderActionMenuContext.Provider, {
    value: {
      setHeaderActionMenu,
      theme$
    }
  }, /*#__PURE__*/_react.default.createElement(_use_monitoring_time.MonitoringTimeContainer, null, /*#__PURE__*/_react.default.createElement(_use_breadcrumbs.BreadcrumbContainer, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/access-denied",
    component: _access_denied.AccessDeniedPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/no-data",
    component: _no_data.NoDataPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/loading",
    component: _loading_page.LoadingPage
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/license",
    component: _license_page.LicensePage,
    codePaths: ['all'],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/home",
    component: _cluster_listing.ClusterListing,
    codePaths: ['all'],
    fetchAllClusters: true,
    unsetGlobalState: true
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/overview",
    component: _overview_page.ClusterOverview,
    codePaths: ['all'],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch/ml_jobs",
    component: _ml_jobs_page.ElasticsearchMLJobsPage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch/ccr/:index/shard/:shardId",
    component: _ccr_shard_page.ElasticsearchCcrShardPage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch/ccr",
    component: _ccr_page.ElasticsearchCcrPage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch/indices/:index/advanced",
    component: _index_advanced_page.ElasticsearchIndexAdvancedPage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch/indices/:index",
    component: _index_page.ElasticsearchIndexPage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch/indices",
    component: _indices_page.ElasticsearchIndicesPage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch/nodes/:node/advanced",
    component: _node_advanced_page.ElasticsearchNodeAdvancedPage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch/nodes/:node",
    component: _node_page.ElasticsearchNodePage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch/nodes",
    component: _nodes_page.ElasticsearchNodesPage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/elasticsearch",
    component: _overview2.ElasticsearchOverviewPage,
    codePaths: [_constants.CODE_PATH_ELASTICSEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/kibana/instances/:instance",
    component: _instance2.KibanaInstancePage,
    codePaths: [_constants.CODE_PATH_KIBANA],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/kibana/instances",
    component: _instances2.KibanaInstancesPage,
    codePaths: [_constants.CODE_PATH_KIBANA],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/kibana",
    component: _overview4.KibanaOverviewPage,
    codePaths: [_constants.CODE_PATH_KIBANA],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/beats/beat/:instance",
    component: _instance.BeatsInstancePage,
    codePaths: [_constants.CODE_PATH_BEATS],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/beats/beats",
    component: _instances.BeatsInstancesPage,
    codePaths: [_constants.CODE_PATH_BEATS],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/beats",
    component: _overview.BeatsOverviewPage,
    codePaths: [_constants.CODE_PATH_BEATS],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/logstash/nodes",
    component: _nodes.LogStashNodesPage,
    codePaths: [_constants.CODE_PATH_LOGSTASH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/logstash/node/:uuid/advanced",
    component: _advanced.LogStashNodeAdvancedPage,
    codePaths: [_constants.CODE_PATH_LOGSTASH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/logstash/node/:uuid/pipelines",
    component: _node_pipelines.LogStashNodePipelinesPage,
    codePaths: [_constants.CODE_PATH_LOGSTASH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/logstash/node/:uuid",
    component: _node.LogStashNodePage,
    codePaths: [_constants.CODE_PATH_LOGSTASH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/logstash/pipelines/:id/:hash?",
    component: _pipeline.LogStashPipelinePage,
    codePaths: [_constants.CODE_PATH_LOGSTASH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/logstash/pipelines",
    component: _pipelines.LogStashPipelinesPage,
    codePaths: [_constants.CODE_PATH_LOGSTASH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/logstash",
    component: _overview5.LogStashOverviewPage,
    codePaths: [_constants.CODE_PATH_LOGSTASH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/apm/instances/:instance",
    component: _apm.ApmInstancePage,
    codePaths: [_constants.CODE_PATH_APM],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/apm/instances",
    component: _apm.ApmInstancesPage,
    codePaths: [_constants.CODE_PATH_APM],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/apm",
    component: _apm.ApmOverviewPage,
    codePaths: [_constants.CODE_PATH_APM],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_route_init.RouteInit, {
    path: "/enterprise_search",
    component: _overview3.EntSearchOverviewPage,
    codePaths: [_constants.CODE_PATH_ENTERPRISE_SEARCH],
    fetchAllClusters: false
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: '/loading',
      search: history.location.search
    }
  })))))))))));
};