"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParser = exports.getLexer = exports.ROOT_STATEMENT = void 0;
var _antlr4ts = require("antlr4ts");
var _esql_lexer = require("../antlr/esql_lexer");
var _esql_parser = require("../antlr/esql_parser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ROOT_STATEMENT = 'singleStatement';
exports.ROOT_STATEMENT = ROOT_STATEMENT;
const getParser = (inputStream, errorListener, parseListener) => {
  const lexer = getLexer(inputStream, errorListener);
  const tokenStream = new _antlr4ts.CommonTokenStream(lexer);
  const parser = new _esql_parser.esql_parser(tokenStream);
  parser.removeErrorListeners();
  parser.addErrorListener(errorListener);
  if (parseListener) {
    parser.addParseListener(parseListener);
  }
  return parser;
};
exports.getParser = getParser;
const getLexer = (inputStream, errorListener) => {
  const lexer = new _esql_lexer.esql_lexer(inputStream);
  lexer.removeErrorListeners();
  lexer.addErrorListener(errorListener);
  return lexer;
};
exports.getLexer = getLexer;