"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jsonSchemaRoutes = jsonSchemaRoutes;
var _app = require("../../common/constants/app");
var _json_schema_schema = require("../../common/api_schemas/json_schema_schema");
var _error_wrapper = require("../client/error_wrapper");
var _json_schema_service = require("../models/json_schema_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function jsonSchemaRoutes({
  router,
  routeGuard
}) {
  /**
   * @apiGroup JsonSchema
   *
   * @api {get} /internal/ml/json_schema Get requested JSON schema
   * @apiName GetJsonSchema
   * @apiDescription Retrieves the JSON schema
   */
  router.versioned.get({
    path: `${_app.ML_INTERNAL_BASE_PATH}/json_schema`,
    access: 'internal',
    options: {
      tags: ['access:ml:canAccessML']
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        query: _json_schema_schema.getJsonSchemaQuerySchema
      }
    }
  }, routeGuard.fullLicenseAPIGuard(async ({
    request,
    response
  }) => {
    try {
      const jsonSchemaService = new _json_schema_service.JsonSchemaService();
      const result = await jsonSchemaService.extractSchema(request.query.path, request.query.method);
      return response.ok({
        body: result
      });
    } catch (e) {
      return response.customError((0, _error_wrapper.wrapError)(e));
    }
  }));
}