"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSearchLinks = registerSearchLinks;
var _i18n = require("@kbn/i18n");
var _search_deep_links = require("./search_deep_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerSearchLinks(appUpdater, isFullLicense, mlCapabilities, showMLNavMenu) {
  appUpdater.next(() => ({
    keywords: [_i18n.i18n.translate('xpack.ml.keyword.ml', {
      defaultMessage: 'ML'
    })],
    deepLinks: (0, _search_deep_links.getDeepLinks)(isFullLicense, mlCapabilities, showMLNavMenu)
  }));
}