"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAnomalyDetectionCreateJobSelectIndex = formatAnomalyDetectionCreateJobSelectIndex;
exports.formatAnomalyDetectionCreateJobSelectType = formatAnomalyDetectionCreateJobSelectType;
exports.formatAnomalyDetectionJobManagementUrl = formatAnomalyDetectionJobManagementUrl;
exports.formatExplorerUrl = formatExplorerUrl;
exports.formatSingleMetricViewerUrl = formatSingleMetricViewerUrl;
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _locator = require("../../../common/constants/locator");
var _common = require("./common");
var _string_utils = require("../../../common/util/string_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates URL to the Anomaly Detection Job management page
 */
function formatAnomalyDetectionJobManagementUrl(appBasePath, params) {
  let url = `${appBasePath}/${_locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE}`;
  if (!params || (0, _lodash.isEmpty)(params)) {
    return url;
  }
  const {
    jobId,
    groupIds,
    globalState
  } = params;
  if (jobId || groupIds) {
    const queryTextArr = [];
    if (jobId) {
      queryTextArr.push((0, _string_utils.getJobQueryText)(jobId));
    }
    if (groupIds) {
      queryTextArr.push((0, _string_utils.getGroupQueryText)(groupIds));
    }
    const jobsListState = {
      ...(queryTextArr.length > 0 ? {
        queryText: queryTextArr.join(' ')
      } : {})
    };
    const queryState = {
      [_locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE]: jobsListState
    };
    url = (0, _public.setStateToKbnUrl)('_a', queryState, {
      useHash: false,
      storeInHashQuery: false
    }, url);
  }
  if (globalState) {
    url = (0, _public.setStateToKbnUrl)('_g', globalState, {
      useHash: false,
      storeInHashQuery: false
    }, url);
  }
  return url;
}
function formatAnomalyDetectionCreateJobSelectType(appBasePath, pageState) {
  return (0, _common.formatGenericMlUrl)(appBasePath, _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_TYPE, pageState);
}
function formatAnomalyDetectionCreateJobSelectIndex(appBasePath, pageState) {
  return (0, _common.formatGenericMlUrl)(appBasePath, _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX, pageState);
}

/**
 * Creates URL to the Anomaly Explorer page
 */
function formatExplorerUrl(appBasePath, params) {
  let url = `${appBasePath}/${_locator.ML_PAGES.ANOMALY_EXPLORER}`;
  if (!params) {
    return url;
  }
  const {
    refreshInterval,
    timeRange,
    jobIds,
    query,
    mlExplorerSwimlane = {},
    mlExplorerFilter = {},
    globalState
  } = params;
  const appState = {
    mlExplorerSwimlane,
    mlExplorerFilter
  };
  let queryState = {};
  if (globalState) queryState = globalState;
  if (query) appState.query = query;
  if (jobIds) {
    queryState.ml = {
      jobIds
    };
  }
  if (refreshInterval) queryState.refreshInterval = refreshInterval;
  if (timeRange) queryState.time = timeRange;
  url = (0, _public.setStateToKbnUrl)('_g', queryState, {
    useHash: false,
    storeInHashQuery: false
  }, url);
  url = (0, _public.setStateToKbnUrl)('_a', {
    [_locator.ML_PAGES.ANOMALY_EXPLORER]: appState
  }, {
    useHash: false,
    storeInHashQuery: false
  }, url);
  return url;
}

/**
 * Creates URL to the SingleMetricViewer page
 */
function formatSingleMetricViewerUrl(appBasePath, params) {
  let url = `${appBasePath}/${_locator.ML_PAGES.SINGLE_METRIC_VIEWER}`;
  if (!params) {
    return url;
  }
  const {
    timeRange,
    jobIds,
    refreshInterval,
    query,
    detectorIndex,
    forecastId,
    entities,
    globalState,
    functionDescription,
    zoom
  } = params;
  let queryState = {};
  if (globalState) queryState = globalState;
  if (jobIds) {
    queryState.ml = {
      jobIds
    };
  }
  if (refreshInterval) queryState.refreshInterval = refreshInterval;
  if (timeRange) queryState.time = timeRange;
  const appState = {};
  const mlTimeSeriesExplorer = {};
  if (forecastId !== undefined) {
    mlTimeSeriesExplorer.forecastId = forecastId;
  }
  if (detectorIndex !== undefined) {
    mlTimeSeriesExplorer.detectorIndex = detectorIndex;
  }
  if (entities !== undefined) {
    mlTimeSeriesExplorer.entities = entities;
  }
  if (functionDescription !== undefined) {
    mlTimeSeriesExplorer.functionDescription = functionDescription;
  }
  if (zoom !== undefined) {
    mlTimeSeriesExplorer.zoom = zoom;
  }
  appState.mlTimeSeriesExplorer = mlTimeSeriesExplorer;
  if (query) appState.query = {
    query_string: query
  };
  url = (0, _public.setStateToKbnUrl)('_g', queryState, {
    useHash: false,
    storeInHashQuery: false
  }, url);
  url = (0, _public.setStateToKbnUrl)('_a', {
    [_locator.ML_PAGES.SINGLE_METRIC_VIEWER]: appState
  }, {
    useHash: false,
    storeInHashQuery: false
  }, url);
  return url;
}