"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySwimlaneInitializer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _explorer_constants = require("../../application/explorer/explorer_constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalySwimlaneInitializer = ({
  defaultTitle,
  influencers,
  onCreate,
  onCancel,
  initialInput
}) => {
  var _initialInput$swimlan;
  const [panelTitle, setPanelTitle] = (0, _react.useState)(defaultTitle);
  const [swimlaneType, setSwimlaneType] = (0, _react.useState)((_initialInput$swimlan = initialInput === null || initialInput === void 0 ? void 0 : initialInput.swimlaneType) !== null && _initialInput$swimlan !== void 0 ? _initialInput$swimlan : _explorer_constants.SWIMLANE_TYPE.OVERALL);
  const [viewBySwimlaneFieldName, setViewBySwimlaneFieldName] = (0, _react.useState)(initialInput === null || initialInput === void 0 ? void 0 : initialInput.viewBy);
  const swimlaneTypeOptions = [{
    id: _explorer_constants.SWIMLANE_TYPE.OVERALL,
    label: _i18n.i18n.translate('xpack.ml.explorer.overallLabel', {
      defaultMessage: 'Overall'
    })
  }, {
    id: _explorer_constants.SWIMLANE_TYPE.VIEW_BY,
    label: _i18n.i18n.translate('xpack.ml.explorer.viewByLabel', {
      defaultMessage: 'View by'
    })
  }];
  const viewBySwimlaneOptions = ['', ...influencers].map(influencer => {
    return {
      value: influencer,
      text: influencer
    };
  });
  const isPanelTitleValid = panelTitle.length > 0;
  const isFormValid = isPanelTitleValid && (swimlaneType === _explorer_constants.SWIMLANE_TYPE.OVERALL || swimlaneType === _explorer_constants.SWIMLANE_TYPE.VIEW_BY && !!viewBySwimlaneFieldName);
  const resultInput = {
    panelTitle,
    swimlaneType,
    ...(viewBySwimlaneFieldName ? {
      viewBy: viewBySwimlaneFieldName
    } : {})
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    initialFocus: "[name=panelTitle]",
    onClose: onCancel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.swimlaneEmbeddable.setupModal.title",
    defaultMessage: "Anomaly swim lane configuration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.swimlaneEmbeddable.panelTitleLabel",
      defaultMessage: "Panel title"
    }),
    isInvalid: !isPanelTitleValid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    id: "panelTitle",
    name: "panelTitle",
    value: panelTitle,
    onChange: e => setPanelTitle(e.target.value),
    isInvalid: !isPanelTitleValid
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.swimlaneEmbeddable.setupModal.swimlaneTypeLabel",
      defaultMessage: "Swim lane type"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    id: "selectSwimlaneType",
    name: "selectSwimlaneType",
    color: "primary",
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.ml.swimlaneEmbeddable.setupModal.swimlaneTypeLabel', {
      defaultMessage: 'Swim lane type'
    }),
    options: swimlaneTypeOptions,
    idSelected: swimlaneType,
    onChange: id => setSwimlaneType(id)
  })), swimlaneType === _explorer_constants.SWIMLANE_TYPE.VIEW_BY && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.viewByLabel",
      defaultMessage: "View by"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: "selectViewBy",
    name: "selectViewBy",
    options: viewBySwimlaneOptions,
    value: viewBySwimlaneFieldName,
    onChange: e => setViewBySwimlaneFieldName(e.target.value)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.swimlaneEmbeddable.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: !isFormValid,
    onClick: onCreate.bind(null, resultInput),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.swimlaneEmbeddable.setupModal.confirmButtonLabel",
    defaultMessage: "Confirm"
  }))));
};
exports.AnomalySwimlaneInitializer = AnomalySwimlaneInitializer;