"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddItemPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React popover for adding items to a filter list.
 */

class AddItemPopover extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onItemsTextChange", e => {
      this.setState({
        itemsText: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState({
        isPopoverOpen: !this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onAddButtonClick", () => {
      const items = this.state.itemsText.split('\n');
      const addItems = [];
      // Remove duplicates.
      items.forEach(item => {
        if (addItems.indexOf(item) === -1 && item.length > 0) {
          addItems.push(item);
        }
      });
      this.props.addItems(addItems);
      this.setState({
        isPopoverOpen: false,
        itemsText: ''
      });
    });
    this.state = {
      isPopoverOpen: false,
      itemsText: ''
    };
  }
  render() {
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      color: "primary",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: this.onButtonClick,
      isDisabled: this.props.canCreateFilter === false,
      "data-test-subj": "mlFilterListOpenNewItemsPopoverButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.settings.filterLists.addItemPopover.addItemButtonLabel",
      defaultMessage: "Add item"
    }));
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "add_item_popover",
      panelClassName: "ml-add-filter-item-popover",
      ownFocus: true,
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      initialFocus: "#filter_list_add_item_input_row"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "filter_list_add_item_input_row",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.settings.filterLists.addItemPopover.itemsLabel",
        defaultMessage: "Items"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      value: this.state.itemsText,
      onChange: this.onItemsTextChange,
      "data-test-subj": 'mlFilterListAddItemTextArea'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.settings.filterLists.addItemPopover.enterItemPerLineDescription",
      defaultMessage: "Enter one item per line"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.onAddButtonClick,
      disabled: this.state.itemsText.length === 0,
      "data-test-subj": 'mlFilterListAddItemsButton'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.settings.filterLists.addItemPopover.addButtonLabel",
      defaultMessage: "Add"
    }))))));
  }
}
exports.AddItemPopover = AddItemPopover;
(0, _defineProperty2.default)(AddItemPopover, "displayName", 'AddItemPopover');
(0, _defineProperty2.default)(AddItemPopover, "propTypes", {
  addItems: _propTypes.default.func.isRequired,
  canCreateFilter: _propTypes.default.bool.isRequired
});