"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _imported_events = require("../imported_events");
var _utils = require("./utils");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_FILE_SIZE_MB = 100;
class ImportModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleImport", async loadedFile => {
      const incomingFile = loadedFile[0];
      const errorMessage = _i18n.i18n.translate('xpack.ml.calendarsEdit.importModal.couldNotParseICSFileErrorMessage', {
        defaultMessage: 'Could not parse ICS file.'
      });
      let events = [];
      if (incomingFile && incomingFile.size <= MAX_FILE_SIZE_MB * 1000000) {
        this.setState({
          fileLoading: true,
          fileLoaded: true
        });
        try {
          const parsedFile = await (0, _utils.readFile)(incomingFile);
          events = (0, _utils.parseICSFile)(parsedFile.data);
          this.setState({
            allImportedEvents: events,
            selectedEvents: (0, _utils.filterEvents)(events),
            fileLoading: false,
            errorMessage: null,
            includePastEvents: false
          });
        } catch (error) {
          console.log(errorMessage, error);
          this.setState({
            errorMessage,
            fileLoading: false
          });
        }
      } else if (incomingFile && incomingFile.size > MAX_FILE_SIZE_MB * 1000000) {
        this.setState({
          fileLoading: false,
          errorMessage
        });
      } else {
        this.setState({
          fileLoading: false,
          errorMessage: null
        });
      }
    });
    (0, _defineProperty2.default)(this, "onEventDelete", eventId => {
      this.setState(prevState => ({
        allImportedEvents: prevState.allImportedEvents.filter(event => event.event_id !== eventId),
        selectedEvents: prevState.selectedEvents.filter(event => event.event_id !== eventId)
      }));
    });
    (0, _defineProperty2.default)(this, "onCheckboxToggle", e => {
      this.setState({
        includePastEvents: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "handleEventsAdd", () => {
      const {
        allImportedEvents,
        selectedEvents,
        includePastEvents
      } = this.state;
      const eventsToImport = includePastEvents ? allImportedEvents : selectedEvents;
      const events = eventsToImport.map(event => ({
        description: event.description,
        start_time: event.start_time,
        end_time: event.end_time,
        event_id: event.event_id
      }));
      this.props.addImportedEvents(events);
    });
    (0, _defineProperty2.default)(this, "renderCallout", () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement("p", null, this.state.errorMessage)));
    this.state = {
      includePastEvents: false,
      allImportedEvents: [],
      selectedEvents: [],
      fileLoading: false,
      fileLoaded: false,
      errorMessage: null
    };
  }
  render() {
    const {
      closeImportModal
    } = this.props;
    const {
      fileLoading,
      fileLoaded,
      allImportedEvents,
      selectedEvents,
      errorMessage,
      includePastEvents
    } = this.state;
    let showRecurringWarning = false;
    let importedEvents;
    if (includePastEvents) {
      importedEvents = allImportedEvents;
    } else {
      importedEvents = selectedEvents;
    }
    if (importedEvents.find(e => e.asterisk) !== undefined) {
      showRecurringWarning = true;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: closeImportModal,
      maxWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.importEventsTitle",
      defaultMessage: "Import events"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.importEventsDescription",
      defaultMessage: "Import events from an ICS file."
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      compressed: true,
      initialPromptText: _i18n.i18n.translate('xpack.ml.calendarsEdit.importModal.selectOrDragAndDropFilePromptText', {
        defaultMessage: 'Select or drag and drop a file'
      }),
      onChange: this.handleImport,
      disabled: fileLoading
    })), errorMessage !== null && this.renderCallout(), allImportedEvents.length > 0 && /*#__PURE__*/_react.default.createElement(_imported_events.ImportedEvents, {
      events: importedEvents,
      showRecurringWarning: showRecurringWarning,
      includePastEvents: includePastEvents,
      onCheckboxToggle: this.onCheckboxToggle,
      onEventDelete: this.onEventDelete
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeImportModal
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.cancelButtonLabel",
      defaultMessage: "Cancel"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.handleEventsAdd,
      fill: true,
      disabled: fileLoaded === false || errorMessage !== null
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.importButtonLabel",
      defaultMessage: "Import"
    })))));
  }
}
exports.ImportModal = ImportModal;
(0, _defineProperty2.default)(ImportModal, "propTypes", {
  addImportedEvents: _propTypes.PropTypes.func.isRequired,
  closeImportModal: _propTypes.PropTypes.func.isRequired
});