"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _anomaly_detection_settings_context = require("./anomaly_detection_settings_context");
var _kibana = require("../contexts/kibana");
var _ml_api_service = require("../services/ml_api_service");
var _locator = require("../../../common/constants/locator");
var _use_create_url = require("../contexts/kibana/use_create_url");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalyDetectionSettings = () => {
  const [calendarsCount, setCalendarsCount] = (0, _react.useState)(0);
  const [filterListsCount, setFilterListsCount] = (0, _react.useState)(0);
  const {
    canGetFilters,
    canCreateFilter,
    canGetCalendars,
    canCreateCalendar
  } = (0, _react.useContext)(_anomaly_detection_settings_context.AnomalyDetectionSettingsContext);
  const {
    toasts
  } = (0, _kibana.useNotifications)();
  const redirectToCalendarList = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.CALENDARS_MANAGE);
  const redirectToNewCalendarPage = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.CALENDARS_NEW);
  const redirectToFilterLists = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.FILTER_LISTS_MANAGE);
  const redirectToNewFilterListPage = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.FILTER_LISTS_NEW);
  (0, _react.useEffect)(() => {
    loadSummaryStats();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  async function loadSummaryStats() {
    // Obtain the counts of calendars and filter lists.
    if (canGetCalendars === true) {
      try {
        const calendars = await _ml_api_service.ml.calendars();
        setCalendarsCount(calendars.length);
      } catch (e) {
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.settings.anomalyDetection.loadingCalendarsCountErrorMessage', {
          defaultMessage: 'An error occurred obtaining the count of calendars'
        }));
      }
    }
    if (canGetFilters === true) {
      try {
        const filterLists = await _ml_api_service.ml.filters.filtersStats();
        setFilterListsCount(filterLists.length);
      } catch (e) {
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.settings.anomalyDetection.loadingFilterListCountErrorMessage', {
          defaultMessage: 'An error occurred obtaining the count of filter lists'
        }));
      }
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.anomalyDetectionTitle",
    defaultMessage: "Anomaly Detection"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.calendarsTitle",
    defaultMessage: "Calendars"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.calendarsText",
    defaultMessage: "Calendars contain a list of scheduled events for which you do not want to generate anomalies, such as planned system outages or public holidays."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, canGetCalendars && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      display: 'block'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.calendarsSummaryCount",
    defaultMessage: "You have {calendarsCountBadge} {calendarsCount, plural, one {calendar} other {calendars}}",
    values: {
      calendarsCountBadge: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, calendarsCount),
      calendarsCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlCalendarsMngButton",
    flush: "left",
    color: "primary",
    onClick: redirectToCalendarList,
    isDisabled: canGetCalendars === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.manageCalendarsLink",
    defaultMessage: "Manage"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlCalendarsCreateButton",
    flush: "left",
    color: "primary",
    onClick: redirectToNewCalendarPage,
    isDisabled: canCreateCalendar === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.createCalendarLink",
    defaultMessage: "Create"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.filterListsTitle",
    defaultMessage: "Filter Lists"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.filterListsText",
    defaultMessage: "Filter lists contain values that you can use to include or exclude events from the machine learning analysis."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, canGetFilters && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.filterListsSummaryCount",
    defaultMessage: "You have {filterListsCountBadge} {filterListsCount, plural, one {filter list} other {filter lists}}",
    values: {
      filterListsCountBadge: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, filterListsCount),
      filterListsCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlFilterListsMngButton",
    flush: "left",
    color: "primary",
    onClick: redirectToFilterLists,
    isDisabled: canGetFilters === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.manageFilterListsLink",
    defaultMessage: "Manage"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlFilterListsCreateButton",
    color: "primary",
    onClick: redirectToNewFilterListPage,
    isDisabled: canCreateFilter === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.createFilterListsLink",
    defaultMessage: "Create"
  })))))));
};
exports.AnomalyDetectionSettings = AnomalyDetectionSettings;