"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newJobCapsService = exports.NewJobCapsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fieldTypes = require("@kbn/field-types");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _fields_utils = require("../../../../common/util/fields_utils");
var _ml_api_service = require("../ml_api_service");
var _new_job_capabilities = require("./new_job_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class NewJobCapsService extends _new_job_capabilities.NewJobCapabilitiesServiceBase {
  constructor(mlApiService) {
    super();
    (0, _defineProperty2.default)(this, "_catFields", []);
    (0, _defineProperty2.default)(this, "_dateFields", []);
    (0, _defineProperty2.default)(this, "_geoFields", []);
    (0, _defineProperty2.default)(this, "_includeEventRateField", true);
    (0, _defineProperty2.default)(this, "_removeTextFields", true);
    (0, _defineProperty2.default)(this, "_mlApiService", void 0);
    this._mlApiService = mlApiService;
  }
  get catFields() {
    return this._catFields;
  }
  get dateFields() {
    return this._dateFields;
  }
  get geoFields() {
    return this._geoFields;
  }
  get categoryFields() {
    return (0, _fields_utils.filterCategoryFields)(this._fields);
  }
  async initializeFromDataVIew(dataView, includeEventRateField = true, removeTextFields = true) {
    try {
      this._includeEventRateField = includeEventRateField;
      this._removeTextFields = removeTextFields;
      const resp = await this._mlApiService.jobs.newJobCaps(dataView.getIndexPattern(), dataView.type === 'rollup');
      const {
        fields: allFields,
        aggs
      } = createObjects(resp, dataView.getIndexPattern());
      if (this._includeEventRateField === true) {
        addEventRateField(aggs, allFields);
      }
      const {
        fieldsPreferringKeyword,
        fieldsPreferringText
      } = (0, _new_job_capabilities.processTextAndKeywordFields)(allFields);
      const catFields = fieldsPreferringText.filter(f => f.type === _fieldTypes.ES_FIELD_TYPES.KEYWORD || f.type === _fieldTypes.ES_FIELD_TYPES.TEXT);
      const dateFields = fieldsPreferringText.filter(f => f.type === _fieldTypes.ES_FIELD_TYPES.DATE);
      const geoFields = (0, _fields_utils.getGeoFields)(allFields);
      const fields = this._removeTextFields ? fieldsPreferringKeyword : allFields;

      // set the main fields list to contain fields which have been filtered to prefer
      // keyword fields over text fields.
      // e.g. if foo.keyword and foo exist, don't add foo to the list.
      this._fields = fields;
      this.removeCounterFields();
      // set the category fields to contain fields which have been filtered to prefer text fields.
      this._catFields = catFields;
      this._dateFields = dateFields;
      this._geoFields = geoFields;
      this._aggs = aggs;
    } catch (error) {
      console.error('Unable to load new job capabilities', error); // eslint-disable-line no-console
    }
  }
}

// using the response from the endpoint, create the field and aggs objects
// when transported over the endpoint, the fields and aggs contain lists of ids of the
// fields and aggs they are related to.
// this function creates lists of real Fields and Aggregations and cross references them.
// the list if ids are then deleted.
exports.NewJobCapsService = NewJobCapsService;
function createObjects(resp, indexPatternTitle) {
  const results = resp[indexPatternTitle];
  const fields = [];
  const aggs = [];
  // for speed, a map of aggregations, keyed on their id

  // create a AggMap type to allow an enum (AggId) to be used as a Record key and then initialized with {}
  const aggMap = {};
  // for speed, a map of aggregation id lists from a field, keyed on the field id
  const aggIdMap = {};
  if (results !== undefined) {
    results.aggs.forEach(a => {
      // create the aggs list
      // only adding a fields list if there is a fieldIds list
      const agg = {
        ...a,
        ...(a.fieldIds !== undefined ? {
          fields: []
        } : {})
      };
      aggMap[agg.id] = agg;
      aggs.push(agg);
    });
    results.fields.forEach(f => {
      // create the fields list
      const field = {
        ...f,
        aggs: []
      };
      if (field.aggIds !== undefined) {
        aggIdMap[field.id] = field.aggIds;
      }
      fields.push(field);
    });

    // loop through the fields and populate their aggs lists.
    // for each agg added to a field, also add that field to the agg's field list
    fields.forEach(field => {
      aggIdMap[field.id].forEach(aggId => {
        mix(field, aggMap[aggId]);
      });
    });
  }

  // the aggIds and fieldIds lists are no longer needed as we've created
  // lists of real fields and aggs
  fields.forEach(f => delete f.aggIds);
  aggs.forEach(a => delete a.fieldIds);
  return {
    fields,
    aggs
  };
}
function mix(field, agg) {
  if (agg.fields === undefined) {
    agg.fields = [];
  }
  if (field.aggs === undefined) {
    field.aggs = [];
  }
  agg.fields.push(field);
  field.aggs.push(agg);
}
function addEventRateField(aggs, fields) {
  const eventRateField = {
    id: _mlAnomalyUtils.EVENT_RATE_FIELD_ID,
    name: 'Event rate',
    type: _fieldTypes.ES_FIELD_TYPES.INTEGER,
    aggregatable: true,
    counter: false,
    aggs: []
  };
  aggs.forEach(a => {
    if (eventRateField.aggs !== undefined && a.fields === undefined) {
      // if the agg's field list is undefined, it is a fieldless aggregation and
      // so can only be used with the event rate field.
      a.fields = [eventRateField];
      eventRateField.aggs.push(a);
    }
  });
  fields.splice(0, 0, eventRateField);
}
const newJobCapsService = new NewJobCapsService(_ml_api_service.ml);
exports.newJobCapsService = newJobCapsService;