"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterListRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _check_ml_nodes = require("../../../ml_nodes_check/check_ml_nodes");
var _filter_lists = require("../../../settings/filter_lists");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterListRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.FILTER_LISTS_MANAGE),
  title: _i18n.i18n.translate('xpack.ml.settings.filterList.docTitle', {
    defaultMessage: 'Filters'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ANOMALY_DETECTION_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('SETTINGS_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('FILTER_LISTS_BREADCRUMB')]
});
exports.filterListRouteFactory = filterListRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetFilters'], {
    getMlNodeCount: _check_ml_nodes.getMlNodeCount
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const [canCreateFilter, canDeleteFilter] = (0, _check_capabilities.usePermissionCheck)(['canCreateFilter', 'canDeleteFilter']);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_filter_lists.FilterLists, {
    canCreateFilter,
    canDeleteFilter
  }));
};