"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fileBasedRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _file_based = require("../../../datavisualizer/file_based");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fileBasedRouteFactory = (navigateToPath, basePath) => ({
  id: 'filedatavisualizer',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_FILE),
  title: _i18n.i18n.translate('xpack.ml.dataVisualizer.file.docTitle', {
    defaultMessage: 'File Data Visualizer'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_VISUALIZER_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.dataVisualizer.fileBasedLabel', {
      defaultMessage: 'File'
    })
  }]
});
exports.fileBasedRouteFactory = fileBasedRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('basic', ['canFindFileStructure']);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_file_based.FileDataVisualizerPage, null));
};