"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataDriftRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _data_drift_page = require("../../../datavisualizer/data_drift/data_drift_page");
var _ml = require("../../../contexts/ml");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _breadcrumbs = require("../../breadcrumbs");
var _resolvers = require("../../resolvers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataDriftRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_drift',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_DRIFT),
  title: _i18n.i18n.translate('xpack.ml.dataVisualizer.dataDrift.docTitle', {
    defaultMessage: 'Data Drift'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), {
    text: _breadcrumbs.DATA_VISUALIZER_BREADCRUMB.text,
    ...(navigateToPath ? {
      href: `${basePath}/app/ml${_breadcrumbs.DATA_DRIFT_BREADCRUMB.href}`,
      onClick: (0, _breadcrumbs.breadcrumbOnClickFactory)(_breadcrumbs.DATA_DRIFT_BREADCRUMB.href, navigateToPath)
    } : {})
  }, {
    text: _i18n.i18n.translate('xpack.ml.trainedModelsBreadcrumbs.dataDriftLabel', {
      defaultMessage: 'Data Drift'
    })
  }],
  'data-test-subj': 'mlPageDataDrift'
});
exports.dataDriftRouteFactory = dataDriftRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', [], (0, _resolvers.basicResolvers)());
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, null, /*#__PURE__*/_react.default.createElement(_data_drift_page.DataDriftPage, null)));
};