"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedModel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _ner = require("./models/ner");
var _question_answering = require("./models/question_answering");
var _text_classification = require("./models/text_classification");
var _text_embedding = require("./models/text_embedding");
var _kibana = require("../../contexts/kibana");
var _inference_input_form = require("./models/inference_input_form");
var _text_expansion = require("./models/text_expansion");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectedModel = ({
  model,
  inputType,
  deploymentId
}) => {
  const {
    trainedModels
  } = (0, _kibana.useMlApiContext)();
  const inferrer = (0, _react.useMemo)(() => {
    if (model.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH) {
      var _model$inference_conf;
      const taskType = Object.keys((_model$inference_conf = model.inference_config) !== null && _model$inference_conf !== void 0 ? _model$inference_conf : {})[0];
      switch (taskType) {
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.NER:
          return new _ner.NerInference(trainedModels, model, inputType, deploymentId);
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_CLASSIFICATION:
          return new _text_classification.TextClassificationInference(trainedModels, model, inputType, deploymentId);
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.ZERO_SHOT_CLASSIFICATION:
          return new _text_classification.ZeroShotClassificationInference(trainedModels, model, inputType, deploymentId);
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EMBEDDING:
          return new _text_embedding.TextEmbeddingInference(trainedModels, model, inputType, deploymentId);
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.FILL_MASK:
          return new _text_classification.FillMaskInference(trainedModels, model, inputType, deploymentId);
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.QUESTION_ANSWERING:
          return new _question_answering.QuestionAnsweringInference(trainedModels, model, inputType, deploymentId);
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EXPANSION:
          return new _text_expansion.TextExpansionInference(trainedModels, model, inputType, deploymentId);
        default:
          break;
      }
    } else if (model.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.LANG_IDENT) {
      return new _text_classification.LangIdentInference(trainedModels, model, inputType, deploymentId);
    }
  }, [inputType, model, trainedModels, deploymentId]);
  (0, _react.useEffect)(() => {
    return () => {
      inferrer === null || inferrer === void 0 ? void 0 : inferrer.destroy();
    };
  }, [inferrer]);
  if (inferrer !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_inference_input_form.InferenceInputForm, {
      inferrer: inferrer,
      inputType: inputType
    });
  }
  return null;
};
exports.SelectedModel = SelectedModel;