"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserConfirmationProvider = exports.StopModelDeploymentsConfirmDialog = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Confirmation is required when there are multiple model deployments
 * or associated pipelines.
 */
const StopModelDeploymentsConfirmDialog = ({
  model,
  onConfirm,
  onCancel
}) => {
  const [checkboxIdToSelectedMap, setCheckboxIdToSelectedMap] = (0, _react.useState)({});
  const options = (0, _react.useMemo)(() => model.deployment_ids.map(deploymentId => {
    return {
      id: deploymentId,
      label: deploymentId
    };
  }), [model.deployment_ids]);
  const onChange = (0, _react.useCallback)(id => {
    setCheckboxIdToSelectedMap(prev => {
      return {
        ...prev,
        [id]: !prev[id]
      };
    });
  }, []);
  const selectedDeploymentIds = (0, _react.useMemo)(() => model.deployment_ids.length > 1 ? Object.keys(checkboxIdToSelectedMap).filter(id => checkboxIdToSelectedMap[id]) : model.deployment_ids, [model.deployment_ids, checkboxIdToSelectedMap]);
  const deploymentPipelinesMap = (0, _react.useMemo)(() => {
    if (!(0, _mlIsPopulatedObject.isPopulatedObject)(model.pipelines)) return {};
    return Object.entries(model.pipelines).reduce((acc, [pipelineId, pipelineDef]) => {
      var _pipelineDef$processo;
      const deploymentIds = ((_pipelineDef$processo = pipelineDef === null || pipelineDef === void 0 ? void 0 : pipelineDef.processors) !== null && _pipelineDef$processo !== void 0 ? _pipelineDef$processo : []).map(v => {
        var _v$inference;
        return v === null || v === void 0 ? void 0 : (_v$inference = v.inference) === null || _v$inference === void 0 ? void 0 : _v$inference.model_id;
      }).filter(_mlIsDefined.isDefined);
      deploymentIds.forEach(dId => {
        if (acc[dId]) {
          acc[dId].push(pipelineId);
        } else {
          acc[dId] = [pipelineId];
        }
      });
      return acc;
    }, {});
  }, [model.pipelines]);
  const pipelineWarning = (0, _react.useMemo)(() => {
    if (model.deployment_ids.length === 1 && (0, _mlIsPopulatedObject.isPopulatedObject)(model.pipelines)) {
      return Object.keys(model.pipelines);
    }
    return [...new Set(Object.entries(deploymentPipelinesMap).filter(([deploymentId]) => selectedDeploymentIds.includes(deploymentId)).flatMap(([, pipelineNames]) => pipelineNames))].sort();
  }, [model, deploymentPipelinesMap, selectedDeploymentIds]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.forceStopDialog.title', {
      defaultMessage: 'Stop {deploymentCount, plural, one {deployment} other {deployments}} of model {modelId}?',
      values: {
        modelId: model.model_id,
        deploymentCount: model.deployment_ids.length
      }
    }),
    onCancel: onCancel,
    onConfirm: onConfirm.bind(null, selectedDeploymentIds),
    cancelButtonText: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.forceStopDialog.cancelText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.forceStopDialog.confirmText', {
      defaultMessage: 'Stop'
    }),
    buttonColor: "danger",
    confirmButtonDisabled: model.deployment_ids.length > 1 && selectedDeploymentIds.length === 0
  }, model.deployment_ids.length > 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    legend: {
      display: 'visible',
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.forceStopDialog.selectDeploymentsLegend",
        defaultMessage: "Select deployments to stop"
      })
    },
    options: options,
    idToSelectedMap: checkboxIdToSelectedMap,
    onChange: onChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  })) : null, pipelineWarning.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.forceStopDialog.pipelinesWarning",
      defaultMessage: "You won't be able to use these ingest pipelines until you restart the model:"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("ul", null, pipelineWarning.map(pipelineName => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: pipelineName
    }, pipelineName);
  }))))) : null);
};
exports.StopModelDeploymentsConfirmDialog = StopModelDeploymentsConfirmDialog;
const getUserConfirmationProvider = (overlays, theme, i18nStart) => async forceStopModel => {
  return new Promise(async (resolve, reject) => {
    try {
      const modalSession = overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(StopModelDeploymentsConfirmDialog, {
        model: forceStopModel,
        onCancel: () => {
          modalSession.close();
          reject();
        },
        onConfirm: deploymentIds => {
          modalSession.close();
          resolve(deploymentIds);
        }
      }), {
        theme,
        i18n: i18nStart
      }));
    } catch (e) {
      reject();
    }
  });
};
exports.getUserConfirmationProvider = getUserConfirmationProvider;