"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.currentMlNodesAvailable = currentMlNodesAvailable;
exports.getMlNodeCount = getMlNodeCount;
exports.getMlNodesCount = getMlNodesCount;
exports.lazyMlNodesAvailable = lazyMlNodesAvailable;
exports.mlNodesAvailable = mlNodesAvailable;
exports.permissionToViewMlNodeCount = permissionToViewMlNodeCount;
var _ml_api_service = require("../services/ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let mlNodeCount = 0;
let lazyMlNodeCount = 0;
let userHasPermissionToViewMlNodeCount = false;
async function getMlNodeCount() {
  try {
    const nodes = await _ml_api_service.ml.mlNodeCount();
    mlNodeCount = nodes.count;
    lazyMlNodeCount = nodes.lazyNodeCount;
    userHasPermissionToViewMlNodeCount = true;
    return nodes;
  } catch (error) {
    mlNodeCount = 0;
    if (error.statusCode === 403) {
      userHasPermissionToViewMlNodeCount = false;
    }
    return {
      count: 0,
      lazyNodeCount: 0
    };
  }
}
function mlNodesAvailable() {
  return mlNodeCount !== 0 || lazyMlNodeCount !== 0;
}
function currentMlNodesAvailable() {
  return mlNodeCount !== 0;
}
function lazyMlNodesAvailable() {
  return lazyMlNodeCount !== 0;
}
function permissionToViewMlNodeCount() {
  return userHasPermissionToViewMlNodeCount;
}
function getMlNodesCount() {
  return mlNodeCount;
}