"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditJob = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _custom_hooks = require("../../../../components/custom_hooks");
var _validators = require("../../../../../../common/util/validators");
var _job_utils = require("../../../../../../common/util/job_utils");
var _validation = require("../../../../../../common/constants/validation");
var _components = require("../../common/components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Edit job flyout for overriding job configuration.
 */
const EditJob = ({
  job,
  jobOverride,
  existingGroupIds,
  onClose
}) => {
  var _formState$jobGroups2;
  const [formState, setFormState] = (0, _custom_hooks.usePartialState)({
    jobGroups: jobOverride && jobOverride.groups || job.config.groups
  });
  const [validationResult, setValidationResult] = (0, _react.useState)({});
  const groupValidator = (0, _validators.composeValidators)(value => (0, _job_utils.isJobIdValid)(value) ? null : {
    pattern: true
  }, (0, _validators.maxLengthValidator)(_validation.JOB_ID_MAX_LENGTH));
  const handleValidation = () => {
    var _formState$jobGroups;
    const jobGroupsValidationResult = ((_formState$jobGroups = formState.jobGroups) !== null && _formState$jobGroups !== void 0 ? _formState$jobGroups : []).map(group => groupValidator(group)).filter(result => result !== null);
    setValidationResult({
      jobGroups: jobGroupsValidationResult,
      formValid: jobGroupsValidationResult.length === 0
    });
  };
  (0, _react.useEffect)(() => {
    handleValidation();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [formState.jobGroups]);
  const onSave = () => {
    const result = {
      job_id: job.id,
      groups: formState.jobGroups
    };
    onClose(result);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => onClose(null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.overrideConfigurationHeader",
    defaultMessage: "Override configuration for {jobID}",
    values: {
      jobID: job.id
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_components.JobGroupsInput, {
    existingGroups: existingGroupIds,
    selectedGroups: (_formState$jobGroups2 = formState.jobGroups) !== null && _formState$jobGroups2 !== void 0 ? _formState$jobGroups2 : [],
    onChange: value => {
      setFormState({
        jobGroups: value
      });
    },
    validation: {
      valid: !validationResult.jobGroups || validationResult.jobGroups.length === 0,
      message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.newJob.recognize.jobGroupAllowedCharactersDescription",
        defaultMessage: "Job group names can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with an alphanumeric character"
      })
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => onClose(null),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.cancelJobOverrideLabel",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onSave(),
    fill: true,
    disabled: !validationResult.formValid
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.saveJobOverrideLabel",
    defaultMessage: "Save"
  }))))));
};
exports.EditJob = EditJob;