"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareFieldSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_field_stats_trigger = require("../../../../../../../components/field_stats_flyout/use_field_stats_trigger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RareFieldSelect = ({
  fields,
  changeHandler,
  selectedField,
  testSubject,
  placeholder
}) => {
  const {
    renderOption,
    optionCss
  } = (0, _use_field_stats_trigger.useFieldStatsTrigger)();
  const options = fields.map(f => ({
    label: f.name,
    field: f,
    css: optionCss
  }));
  const selection = [];
  if (selectedField !== null) {
    selection.push({
      label: selectedField.name,
      field: selectedField
    });
  }
  function onChange(selectedOptions) {
    const option = selectedOptions[0];
    if (typeof option !== 'undefined') {
      changeHandler(option.field);
    } else {
      changeHandler(null);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selection,
    onChange: onChange,
    placeholder: placeholder,
    "data-test-subj": testSubject,
    isClearable: false,
    renderOption: renderOption
  });
};
exports.RareFieldSelect = RareFieldSelect;