"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrequencyInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _job_utils = require("../../../../../../../../../common/util/job_utils");
var _hooks = require("../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FrequencyInput = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.frequency);
  const {
    value: frequency,
    setValue: setFrequency
  } = (0, _hooks.useStringifiedValue)(jobCreator.frequency);
  const [defaultFrequency, setDefaultFrequency] = (0, _react.useState)(createDefaultFrequency());
  (0, _react.useEffect)(() => {
    jobCreator.frequency = frequency === '' ? null : frequency;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [frequency]);
  (0, _react.useEffect)(() => {
    setFrequency(jobCreator.frequency);
    const df = createDefaultFrequency();
    setDefaultFrequency(df);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.frequency);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  function createDefaultFrequency() {
    const df = (0, _job_utils.calculateDatafeedFrequencyDefaultSeconds)(jobCreator.bucketSpanMs / 1000);
    return `${df}s`;
  }
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: frequency,
    placeholder: defaultFrequency,
    onChange: e => setFrequency(e.target.value),
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardInputFrequency"
  }));
};
exports.FrequencyInput = FrequencyInput;