"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartDatafeedModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _utils = require("../utils");
var _time_range_selector = require("./time_range_selector");
var _i18nReact = require("@kbn/i18n-react");
var _jobs_utils = require("../../../jobs_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StartDatafeedModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "setStartTime", time => {
      this.setState({
        startTime: time
      });
    });
    (0, _defineProperty2.default)(this, "setEndTime", time => {
      this.setState({
        endTime: time
      });
    });
    (0, _defineProperty2.default)(this, "setCreateAlert", e => {
      this.setState({
        createAlert: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "closeModal", () => {
      this.setState({
        isModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "setTimeRangeValid", timeRangeValid => {
      this.setState({
        timeRangeValid
      });
    });
    (0, _defineProperty2.default)(this, "showModal", (jobs, showCreateAlertFlyout) => {
      const startTime = undefined;
      const now = (0, _moment.default)();
      const endTime = now;
      const initialSpecifiedStartTime = getLowestLatestTime(jobs);
      const allowCreateAlert = jobs.length > 0;
      this.setState({
        jobs,
        isModalVisible: true,
        startTime,
        endTime,
        initialSpecifiedStartTime,
        showCreateAlertFlyout,
        allowCreateAlert,
        createAlert: false,
        now,
        hasManagedJob: jobs.some(j => (0, _jobs_utils.isManagedJob)(j))
      });
    });
    (0, _defineProperty2.default)(this, "save", () => {
      const {
        jobs
      } = this.state;
      const start = _moment.default.isMoment(this.state.startTime) ? this.state.startTime.valueOf() : this.state.startTime;
      const end = _moment.default.isMoment(this.state.endTime) ? this.state.endTime.valueOf() : this.state.endTime;
      (0, _utils.forceStartDatafeeds)(jobs, start, end, () => {
        if (this.state.createAlert && jobs.length > 0) {
          this.getShowCreateAlertFlyoutFunction()(jobs.map(job => job.id));
        }
        this.refreshJobs();
      });
      this.closeModal();
    });
    const _now = (0, _moment.default)();
    this.state = {
      jobs: this.props.jobs,
      isModalVisible: false,
      startTime: _now,
      endTime: _now,
      createAlert: false,
      allowCreateAlert: false,
      initialSpecifiedStartTime: _now,
      now: _now,
      timeRangeValid: true,
      hasManagedJob: false
    };
    this.initialSpecifiedStartTime = _now;
    this.refreshJobs = this.props.refreshJobs;
    this.getShowCreateAlertFlyoutFunction = this.props.getShowCreateAlertFlyoutFunction;
  }
  componentDidMount() {
    if (typeof this.props.setShowFunction === 'function') {
      this.props.setShowFunction(this.showModal);
    }
  }
  componentWillUnmount() {
    if (typeof this.props.unsetShowFunction === 'function') {
      this.props.unsetShowFunction();
    }
  }
  render() {
    const {
      jobs,
      initialSpecifiedStartTime,
      startTime,
      endTime,
      createAlert,
      now,
      timeRangeValid
    } = this.state;
    const startableJobs = jobs !== undefined ? jobs.filter(j => j.hasDatafeed) : [];
    // disable start button if the start and end times are the same
    const startDisabled = timeRangeValid === false || startTime !== undefined && startTime === endTime;
    let modal;
    if (this.state.isModalVisible) {
      modal = /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
        onClose: this.closeModal,
        style: {
          minWidth: '850px'
        },
        maxWidth: false,
        "data-test-subj": "mlStartDatafeedModal"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.startJobsTitle",
        defaultMessage: "Start {jobsCount, plural, one {{jobId}} other {# jobs}}",
        values: {
          jobsCount: startableJobs.length,
          jobId: startableJobs[0].id
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_time_range_selector.TimeRangeSelector, {
        startTime: startTime === undefined ? initialSpecifiedStartTime : startTime,
        endTime: endTime,
        setStartTime: this.setStartTime,
        setEndTime: this.setEndTime,
        now: now,
        setTimeRangeValid: this.setTimeRangeValid,
        hasManagedJob: this.state.hasManagedJob,
        jobsCount: startableJobs.length
      }), this.state.endTime === undefined && /*#__PURE__*/_react.default.createElement("div", {
        className: "create-watch"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: "createAlert",
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.jobsList.startDatafeedModal.createAlertDescription",
          defaultMessage: "Create alert rule after datafeed has started"
        }),
        checked: createAlert,
        onChange: this.setCreateAlert
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: this.closeModal,
        "data-test-subj": "mlStartDatafeedModalCancelButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.save,
        isDisabled: startDisabled,
        fill: true,
        "data-test-subj": "mlStartDatafeedModalStartButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.startButtonLabel",
        defaultMessage: "Start"
      }))));
    }
    return /*#__PURE__*/_react.default.createElement("div", null, modal);
  }
}
exports.StartDatafeedModal = StartDatafeedModal;
StartDatafeedModal.propTypes = {
  setShowFunction: _propTypes.default.func.isRequired,
  unsetShowFunction: _propTypes.default.func.isRequired,
  refreshJobs: _propTypes.default.func.isRequired
};
function getLowestLatestTime(jobs) {
  const times = jobs.map(j => j.earliestStartTimestampMs || 0);
  return (0, _moment.default)(Math.min(...times));
}