"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenJobsWarningCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _states = require("../../../../../../common/constants/states");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OpenJobsWarningCallout = ({
  jobs
}) => {
  const openJobsCount = (0, _react.useMemo)(() => jobs.filter(j => j.jobState !== _states.JOB_STATE.CLOSED).length, [jobs]);
  if (openJobsCount === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.resetJobModal.openJobsWarningCallout.title",
      defaultMessage: "{openJobsCount, plural, one {# job is} other {# jobs are}} not closed",
      values: {
        openJobsCount
      }
    }),
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.openJobsWarningCallout.description1",
    defaultMessage: "{openJobsCount, plural, one {This job} other {These jobs}} must be closed before {openJobsCount, plural, one {it} other {they}} can be reset. ",
    values: {
      openJobsCount
    }
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.openJobsWarningCallout.description2",
    defaultMessage: "{openJobsCount, plural, one {This job} other {These jobs}} will not be reset when clicking the Reset button below.",
    values: {
      openJobsCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.OpenJobsWarningCallout = OpenJobsWarningCallout;