"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartLabel = ExplorerChartLabel;
require("./_explorer_chart_label.scss");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _explorer_chart_label_badge = require("./explorer_chart_label_badge");
var _explorer_chart_info_tooltip = require("../../explorer_chart_info_tooltip");
var _entity_filter = require("./entity_filter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExplorerChartLabel({
  detectorLabel,
  entityFields,
  infoTooltip,
  wrapLabel = false,
  onSelectEntity
}) {
  // Depending on whether we wrap the entityField badges to a new line, we render this differently:
  //
  // 1. All in one line:
  //   <detectorLabel> - <entityBadge1> <entityBadge2> ... <infoIcon>
  //
  // 2. Multiple lines:
  //   <detectorLabel> <infoIcon>
  //   <entityBadge1> <entityBadge2> ...

  // Using &nbsp;s here to make sure those spaces get rendered.
  const labelSeparator = wrapLabel === true || entityFields.length === 0 || detectorLabel.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0\u2013\xA0");
  const applyFilter = (0, _react.useCallback)(({
    influencerFieldName,
    influencerFieldValue,
    action
  }) => onSelectEntity(influencerFieldName, influencerFieldValue, action), [onSelectEntity]);
  const entityFieldBadges = entityFields.map(entity => {
    const key = `${infoTooltip.chartFunction}-${entity.fieldName}-${entity.fieldType}-${entity.fieldValue}`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `badge-wrapper-${key}`
    }, /*#__PURE__*/_react.default.createElement(_explorer_chart_label_badge.ExplorerChartLabelBadge, {
      entity: entity
    }), onSelectEntity !== undefined && /*#__PURE__*/_react.default.createElement(_entity_filter.EntityFilter, {
      onFilter: applyFilter,
      influencerFieldName: entity.fieldName,
      influencerFieldValue: entity.fieldValue
    }));
  });
  const infoIcon = /*#__PURE__*/_react.default.createElement("span", {
    className: "ml-explorer-chart-info-icon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    className: "ml-explorer-chart-eui-icon-tip",
    content: /*#__PURE__*/_react.default.createElement(_explorer_chart_info_tooltip.ExplorerChartInfoTooltip, infoTooltip),
    position: "top",
    size: "s"
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    className: "ml-explorer-chart-label"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "ml-explorer-chart-label-detector"
  }, detectorLabel, labelSeparator), wrapLabel && infoIcon, !wrapLabel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, entityFieldBadges, " ", infoIcon)), wrapLabel && /*#__PURE__*/_react.default.createElement("span", {
    className: "ml-explorer-chart-label-badges"
  }, entityFieldBadges));
}
ExplorerChartLabel.propTypes = {
  detectorLabel: _propTypes.default.object.isRequired,
  entityFields: _propTypes.default.arrayOf(_explorer_chart_label_badge.ExplorerChartLabelBadge.propTypes.entity),
  infoTooltip: _propTypes.default.object.isRequired,
  wrapLabel: _propTypes.default.bool
};