"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsSummary = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _const = require("./const");
var _render_cell_value = require("../../../alerting/anomaly_detection_alerts_table/render_cell_value");
var _kibana = require("../../contexts/kibana");
var _anomaly_explorer_context = require("../anomaly_explorer_context");
var _get_alerts_summary = require("./get_alerts_summary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE = 3;
const AlertsSummary = () => {
  const {
    services: {
      fieldFormats
    }
  } = (0, _kibana.useMlKibana)();
  const {
    anomalyDetectionAlertsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const alertsData = (0, _useObservable.default)(anomalyDetectionAlertsStateService.anomalyDetectionAlerts$, []);
  const formatter = (0, _render_cell_value.getAlertFormatters)(fieldFormats);
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const sortedAlertsByRule = (0, _react.useMemo)(() => {
    return (0, _get_alerts_summary.getAlertsSummary)(alertsData);
  }, [alertsData]);
  const pageItems = (0, _react.useMemo)(() => {
    return sortedAlertsByRule.slice(activePage * PAGE_SIZE, (activePage + 1) * PAGE_SIZE);
  }, [activePage, sortedAlertsByRule]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    gutterSize: 'm'
  }, pageItems.map(([ruleName, ruleSummary]) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: ruleName,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xs'
    }, /*#__PURE__*/_react.default.createElement("h5", null, ruleName))), ruleSummary.activeCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "accent"
    }, _const.statusNameMap.active)) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: "column",
      listItems: [{
        title: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.totalAlerts', {
          defaultMessage: 'Total alerts: '
        }),
        description: ruleSummary.totalCount
      }, ...(ruleSummary.activeCount > 0 ? [{
        title: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.startedAt', {
          defaultMessage: 'Started at: '
        }),
        description: formatter(_ruleDataUtils.ALERT_END, ruleSummary.startedAt)
      }] : [{
        title: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.recoveredAt', {
          defaultMessage: 'Recovered at: '
        }),
        description: formatter(_ruleDataUtils.ALERT_END, ruleSummary.recoveredAt)
      }]), {
        title: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.lastDuration', {
          defaultMessage: 'Last duration: '
        }),
        description: formatter(_ruleDataUtils.ALERT_DURATION, ruleSummary.lastDuration)
      }]
    }));
  })), sortedAlertsByRule.length > PAGE_SIZE ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.paginationAreaLabel', {
      defaultMessage: 'Pagination for alerting rules summary'
    }),
    pageCount: Math.ceil(sortedAlertsByRule.length / PAGE_SIZE),
    activePage: activePage,
    onPageClick: setActivePage
  }))) : null);
};
exports.AlertsSummary = AlertsSummary;