"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _register_alerts_table_configuration = require("../../../alerting/anomaly_detection_alerts_table/register_alerts_table_configuration");
var _collapsible_panel = require("../../components/collapsible_panel");
var _kibana = require("../../contexts/kibana");
var _anomaly_explorer_context = require("../anomaly_explorer_context");
var _alerts_summary = require("./alerts_summary");
var _chart = require("./chart");
var _const = require("./const");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsPanel = () => {
  const {
    services: {
      triggersActionsUi
    }
  } = (0, _kibana.useMlKibana)();
  const [isOpen, setIsOpen] = (0, _react.useState)(true);
  const [toggleSelected, setToggleSelected] = (0, _react.useState)(`alertsSummary`);
  const {
    anomalyDetectionAlertsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const countByStatus = (0, _useObservable.default)(anomalyDetectionAlertsStateService.countByStatus$);
  const alertsQuery = (0, _useObservable.default)(anomalyDetectionAlertsStateService.alertsQuery$, {});
  const isLoading = (0, _useObservable.default)(anomalyDetectionAlertsStateService.isLoading$, true);
  const alertStateProps = {
    alertsTableConfigurationRegistry: triggersActionsUi.alertsTableConfigurationRegistry,
    configurationId: _register_alerts_table_configuration.ML_ALERTS_CONFIG_ID,
    id: `ml-details-alerts`,
    featureIds: [_ruleDataUtils.AlertConsumers.ML],
    query: alertsQuery,
    showExpandToDetails: true,
    showAlertStatusWithFlapping: true
  };
  const alertsStateTable = triggersActionsUi.getAlertsStateTable(alertStateProps);
  const toggleButtons = [{
    id: `alertsSummary`,
    label: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summaryLabel', {
      defaultMessage: 'Summary'
    })
  }, {
    id: `alertsTable`,
    label: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.detailsLabel', {
      defaultMessage: 'Details'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
    isOpen: isOpen,
    onToggle: setIsOpen,
    header: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: 'center',
      gutterSize: 'xs'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.alertsPanel.header",
      defaultMessage: "Alerts"
    })), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: 'm'
    })) : null),
    headerItems: Object.entries(countByStatus !== null && countByStatus !== void 0 ? countByStatus : {}).map(([status, count]) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _const.statusNameMap[status], ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        size: "m",
        color: status === _ruleDataUtils.ALERT_STATUS_ACTIVE ? 'accent' : 'subdued'
      }, count));
    })
  }, /*#__PURE__*/_react.default.createElement(_chart.AnomalyDetectionAlertsOverviewChart, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summaryTableToggle', {
      defaultMessage: 'Summary / Table view toggle'
    }),
    options: toggleButtons,
    idSelected: toggleSelected,
    onChange: setToggleSelected
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), toggleSelected === 'alertsTable' ? alertsStateTable : /*#__PURE__*/_react.default.createElement(_alerts_summary.AlertsSummary, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.AlertsPanel = AlertsPanel;