"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDataVisualizerPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _kibana = require("../../contexts/kibana");
var _help_menu = require("../../components/help_menu");
var _locator = require("../../../../common/constants/locator");
var _license = require("../../license");
var _check_ml_nodes = require("../../ml_nodes_check/check_ml_nodes");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _page_header = require("../../components/page_header");
var _ml = require("../../contexts/ml");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexDataVisualizerPage = () => {
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const {
    services: {
      docLinks,
      dataVisualizer,
      data: {
        dataViews: {
          get: getDataView
        }
      },
      mlServices: {
        mlApiServices: {
          recognizeIndex
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const mlFeaturesDisabled = !(0, _license.isFullLicense)();
  (0, _check_ml_nodes.getMlNodeCount)();
  const [IndexDataVisualizer, setIndexDataVisualizer] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (dataVisualizer !== undefined) {
      const {
        getIndexDataVisualizerComponent
      } = dataVisualizer;
      getIndexDataVisualizerComponent().then(setIndexDataVisualizer);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const getAsyncMLCards = async ({
    dataViewId,
    dataViewTitle,
    globalState
  }) => {
    return [{
      id: 'create_ml_ad_job',
      title: _i18n.i18n.translate('xpack.ml.indexDatavisualizer.actionsPanel.anomalyDetectionTitle', {
        defaultMessage: 'Advanced anomaly detection'
      }),
      description: _i18n.i18n.translate('xpack.ml.indexDatavisualizer.actionsPanel.anomalyDetectionDescription', {
        defaultMessage: 'Create a job with the full range of options for more advanced use cases.'
      }),
      icon: 'createAdvancedJob',
      type: 'file',
      getUrl: async () => {
        return await mlLocator.getUrl({
          page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_ADVANCED,
          pageState: {
            index: dataViewId,
            globalState
          }
        });
      },
      canDisplay: async () => {
        try {
          const {
            timeFieldName
          } = await getDataView(dataViewId);
          return (0, _license.isFullLicense)() && timeFieldName !== undefined && (0, _check_capabilities.checkPermission)('canCreateJob') && (0, _check_ml_nodes.mlNodesAvailable)();
        } catch (error) {
          return false;
        }
      },
      'data-test-subj': 'dataVisualizerCreateAdvancedJobCard'
    }, {
      id: 'create_ml_dfa_job',
      title: _i18n.i18n.translate('xpack.ml.indexDatavisualizer.actionsPanel.dataframeTitle', {
        defaultMessage: 'Data frame analytics'
      }),
      description: _i18n.i18n.translate('xpack.ml.indexDatavisualizer.actionsPanel.dataframeDescription', {
        defaultMessage: 'Create outlier detection, regression, or classification analytics.'
      }),
      icon: 'classificationJob',
      type: 'file',
      getUrl: async () => {
        return await mlLocator.getUrl({
          page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB,
          pageState: {
            index: dataViewId,
            globalState
          }
        });
      },
      canDisplay: async () => {
        return (0, _license.isFullLicense)() && (0, _check_capabilities.checkPermission)('canCreateDataFrameAnalytics') && (0, _check_ml_nodes.mlNodesAvailable)();
      },
      'data-test-subj': 'dataVisualizerCreateDataFrameAnalyticsCard'
    }];
  };
  const getAsyncRecognizedModuleCards = async params => {
    const {
      dataViewId,
      dataViewTitle
    } = params;
    try {
      const modules = await recognizeIndex({
        indexPatternTitle: dataViewTitle
      });
      return modules === null || modules === void 0 ? void 0 : modules.map(m => {
        var _m$logo$icon, _m$logo;
        return {
          id: m.id,
          title: m.title,
          description: m.description,
          icon: (_m$logo$icon = (_m$logo = m.logo) === null || _m$logo === void 0 ? void 0 : _m$logo.icon) !== null && _m$logo$icon !== void 0 ? _m$logo$icon : '',
          type: 'index',
          getUrl: async () => {
            return await mlLocator.getUrl({
              page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RECOGNIZER,
              pageState: {
                id: m.id,
                index: dataViewId
              }
            });
          },
          canDisplay: async () => {
            try {
              const {
                timeFieldName
              } = await getDataView(dataViewId);
              return (0, _license.isFullLicense)() && timeFieldName !== undefined && (0, _check_capabilities.checkPermission)('canCreateJob') && (0, _check_ml_nodes.mlNodesAvailable)();
            } catch (error) {
              return false;
            }
          },
          'data-test-subj': m.id
        };
      });
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error('Platinum, Enterprise or trial license needed');
      return [];
    }
  };
  const getAdditionalLinks = (0, _react.useMemo)(() => mlFeaturesDisabled ? [] : [getAsyncRecognizedModuleCards, getAsyncMLCards],
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [mlLocator, mlFeaturesDisabled]);
  return IndexDataVisualizer ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, IndexDataVisualizer !== null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataVisualizer.pageHeader",
    defaultMessage: "Data Visualizer"
  })), /*#__PURE__*/_react.default.createElement(IndexDataVisualizer, {
    getAdditionalLinks: getAdditionalLinks,
    showFrozenDataTierChoice: showNodeInfo
  })) : null, /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: docLinks.links.ml.guide
  })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null);
};
exports.IndexDataVisualizerPage = IndexDataVisualizerPage;