"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = exports.progressColumn = exports.getTaskStateBadge = exports.getJobTypeBadge = exports.DFAnalyticsJobIdLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _common = require("./common");
var _use_actions = require("./use_actions");
var _kibana = require("../../../../../contexts/kibana");
var _locator = require("../../../../../../../common/constants/locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRUNCATE_TEXT_LINES = 3;
var TASK_STATE_COLOR;
(function (TASK_STATE_COLOR) {
  TASK_STATE_COLOR["analyzing"] = "primary";
  TASK_STATE_COLOR["failed"] = "danger";
  TASK_STATE_COLOR["reindexing"] = "primary";
  TASK_STATE_COLOR["started"] = "primary";
  TASK_STATE_COLOR["starting"] = "primary";
  TASK_STATE_COLOR["stopped"] = "hollow";
  TASK_STATE_COLOR["stopping"] = "hollow";
})(TASK_STATE_COLOR || (TASK_STATE_COLOR = {}));
const getTaskStateBadge = (state, failureReason) => {
  const color = TASK_STATE_COLOR[state];
  if ((0, _common.isDataFrameAnalyticsFailed)(state) && failureReason !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: failureReason
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      className: "mlTaskStateBadge",
      color: color
    }, state));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "mlTaskStateBadge",
    color: color
  }, state);
};
exports.getTaskStateBadge = getTaskStateBadge;
const getJobTypeBadge = jobType => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  className: "mlTaskStateBadge",
  color: "hollow"
}, jobType);
exports.getJobTypeBadge = getJobTypeBadge;
const progressColumn = {
  name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.progress', {
    defaultMessage: 'Progress'
  }),
  truncateText: true,
  render(item) {
    const {
      currentPhase,
      progress,
      totalPhases
    } = (0, _common.getDataFrameAnalyticsProgressPhase)(item.stats);

    // For now all analytics jobs are batch jobs.
    const isBatchTransform = true;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, isBatchTransform && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: '60px'
      },
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, "Phase ", currentPhase, "/", totalPhases)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: '40px'
      },
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.progressOfPhase', {
        defaultMessage: 'Progress of phase {currentPhase}: {progress}%',
        values: {
          currentPhase,
          progress
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      value: progress,
      max: 100,
      color: "primary",
      size: "m",
      "data-test-subj": "mlAnalyticsTableProgress"
    })))), !isBatchTransform && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: '40px'
      },
      grow: false
    }, (0, _common.isDataFrameAnalyticsRunning)(item.stats.state) && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      color: "primary",
      size: "m"
    }), (0, _common.isDataFrameAnalyticsStopped)(item.stats.state) && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      value: 0,
      max: 100,
      color: "primary",
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: '35px'
      },
      grow: false
    }, "\xA0")));
  },
  width: '130px',
  'data-test-subj': 'mlAnalyticsTableColumnProgress'
};
exports.progressColumn = progressColumn;
const DFAnalyticsJobIdLink = ({
  jobId
}) => {
  const href = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE,
    pageState: {
      jobId
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    css: {
      overflow: 'hidden',
      'text-overflow': 'ellipsis'
    },
    title: jobId
  }, jobId);
};
exports.DFAnalyticsJobIdLink = DFAnalyticsJobIdLink;
const useColumns = (expandedRowItemIds, setExpandedRowItemIds, isMlEnabledInSpace = true, refresh = () => {}) => {
  const {
    actions,
    modals
  } = (0, _use_actions.useActions)();
  function toggleDetails(item) {
    const index = expandedRowItemIds.indexOf(item.config.id);
    if (index !== -1) {
      expandedRowItemIds.splice(index, 1);
      setExpandedRowItemIds([...expandedRowItemIds]);
    } else {
      expandedRowItemIds.push(item.config.id);
    }

    // spread to a new array otherwise the component wouldn't re-render
    setExpandedRowItemIds([...expandedRowItemIds]);
  }
  // update possible column types to something like (FieldDataColumn | ComputedColumn | ActionsColumn)[] when they have been added to EUI
  const columns = [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analyticsList.showDetailsColumn.screenReaderDescription",
      defaultMessage: "This column contains clickable controls for showing more details on each job"
    }))),
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleDetails(item),
      "aria-label": expandedRowItemIds.includes(item.config.id) ? _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.rowCollapse', {
        defaultMessage: 'Hide details for {analyticsId}',
        values: {
          analyticsId: item.config.id
        }
      }) : _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.rowExpand', {
        defaultMessage: 'Show details for {analyticsId}',
        values: {
          analyticsId: item.config.id
        }
      }),
      iconType: expandedRowItemIds.includes(item.config.id) ? 'arrowDown' : 'arrowRight'
    }),
    'data-test-subj': 'mlAnalyticsTableRowDetailsToggle'
  }, {
    field: _common.DataFrameAnalyticsListColumn.id,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.id', {
      defaultMessage: 'ID'
    }),
    sortable: item => item.id,
    truncateText: {
      lines: TRUNCATE_TEXT_LINES
    },
    'data-test-subj': 'mlAnalyticsTableColumnId',
    scope: 'row',
    render: id => {
      return /*#__PURE__*/_react.default.createElement("span", {
        title: id
      }, id);
    }
  }, {
    field: _common.DataFrameAnalyticsListColumn.description,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.description', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    truncateText: {
      lines: TRUNCATE_TEXT_LINES
    },
    'data-test-subj': 'mlAnalyticsTableColumnJobDescription',
    render: description => {
      return /*#__PURE__*/_react.default.createElement("span", {
        title: description
      }, description);
    }
  }, {
    field: _common.DataFrameAnalyticsListColumn.memoryStatus,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.memoryStatus', {
      defaultMessage: 'Memory status'
    }),
    truncateText: true,
    'data-test-subj': 'mlAnalyticsTableColumnJobMemoryStatus'
  }, {
    field: _common.DataFrameAnalyticsListColumn.configSourceIndex,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.sourceIndex', {
      defaultMessage: 'Source index'
    }),
    sortable: true,
    truncateText: true,
    'data-test-subj': 'mlAnalyticsTableColumnSourceIndex'
  }, {
    field: _common.DataFrameAnalyticsListColumn.configDestIndex,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.destinationIndex', {
      defaultMessage: 'Destination index'
    }),
    sortable: true,
    truncateText: true,
    'data-test-subj': 'mlAnalyticsTableColumnDestIndex'
  }, {
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.type', {
      defaultMessage: 'Type'
    }),
    sortable: item => (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(item.config.analysis),
    truncateText: true,
    render(item) {
      return getJobTypeBadge((0, _mlDataFrameAnalyticsUtils.getAnalysisType)(item.config.analysis));
    },
    width: '150px',
    'data-test-subj': 'mlAnalyticsTableColumnType'
  }, {
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.status', {
      defaultMessage: 'Status'
    }),
    sortable: item => item.stats.state,
    truncateText: true,
    render(item) {
      return getTaskStateBadge(item.stats.state, item.stats.failure_reason);
    },
    width: '100px',
    'data-test-subj': 'mlAnalyticsTableColumnStatus'
  }, progressColumn, {
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.tableActionLabel', {
      defaultMessage: 'Actions'
    }),
    actions,
    width: '150px',
    'data-test-subj': 'mlAnalyticsTableColumnActions'
  }];
  return {
    columns,
    modals
  };
};
exports.useColumns = useColumns;